/*
 * Decompiled with CFR 0.152.
 */
package com.watayouxiang.wallet.feature.recharge.mvp;

import android.content.Context;
import com.blankj.utilcode.util.ToastUtils;
import com.ehking.sdk.wepay.interfaces.WalletPay;
import com.ehking.sdk.wepay.net.bean.AuthType;
import com.watayouxiang.androidutils.mvp.BaseModel;
import com.watayouxiang.androidutils.widget.TioToast;
import com.watayouxiang.httpclient.model.response.PayRechargeResp;
import com.watayouxiang.wallet.feature.recharge.mvp.Contract;
import com.watayouxiang.wallet.feature.recharge.mvp.Model;
import com.watayouxiang.wallet.feature.recharge_result.RechargeResultActivity;
import com.watayouxiang.wallet.tools.MoneyUtils;

public class Presenter
extends Contract.Presenter {
    public Presenter(Contract.View view) {
        super(new Model(), view, false);
    }

    @Override
    public void init() {
        ((Contract.View)this.getView()).resetUI();
    }

    @Override
    public void walletRecharge(String amount) {
        String format = MoneyUtils.yuan2fen(amount);
        if (format == null) {
            TioToast.showShort((CharSequence)"\u91d1\u989d\u683c\u5f0f\u5316\u9519\u8bef");
            return;
        }
        ((Contract.Model)this.getModel()).postRecharge(format, new BaseModel.DataProxy<PayRechargeResp>(){

            public void onSuccess(PayRechargeResp payRechargeResp) {
                super.onSuccess((Object)payRechargeResp);
                Presenter.this.evokeRecharge$SDK(payRechargeResp);
            }

            public void onFailure(String msg) {
                super.onFailure(msg);
                ToastUtils.showShort((CharSequence)msg);
            }
        });
    }

    private void evokeRecharge$SDK(PayRechargeResp resp) {
        String merchantId = resp.getMerchantId();
        String walletId = resp.getWalletId();
        String token = resp.getToken();
        WalletPay walletPay = WalletPay.Companion.getInstance();
        walletPay.init(((Contract.View)this.getView()).getActivity());
        walletPay.setWalletPayCallback((source, status, errorMessage) -> {
            if ("SUCCESS".equals(status) || "PROCESS".equals(status)) {
                ((Contract.View)this.getView()).finish();
                RechargeResultActivity.start((Context)((Contract.View)this.getView()).getActivity(), resp.getSerialnumber());
            } else {
                TioToast.showShort((CharSequence)errorMessage);
            }
        });
        walletPay.evoke(merchantId, walletId, token, AuthType.RECHARGE.name());
    }
}

