/*
 * Decompiled with CFR 0.152.
 */
package com.watayouxiang.wallet.feature.paperdetail.adapter;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.widget.TextView;
import com.chad.library.adapter.base.BaseMultiItemQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.watayouxiang.androidutils.utils.ClickUtils;
import com.watayouxiang.androidutils.widget.imageview.TioImageView;
import com.watayouxiang.wallet.R;
import com.watayouxiang.wallet.feature.paperdetail.adapter.FooterItem;
import com.watayouxiang.wallet.feature.paperdetail.adapter.ListItem;
import com.watayouxiang.wallet.feature.paperdetail.adapter.ListModel;
import com.watayouxiang.wallet.feature.paperdetail.adapter.ReceiveInfoItem;
import com.watayouxiang.wallet.feature.paperdetail.adapter.SendInfoItem;
import com.watayouxiang.wallet.feature.wallet.WalletActivity;
import java.util.List;

public class ListAdapter
extends BaseMultiItemQuickAdapter<ListModel, BaseViewHolder> {
    public ListAdapter(List<ListModel> data) {
        super(data);
        this.addItemType(1, R.layout.wallet_paperdetail_list_item);
        this.addItemType(2, R.layout.wallet_paperdetail_sendinfo_item);
        this.addItemType(3, R.layout.wallet_paperdetail_footer_item);
        this.addItemType(4, R.layout.wallet_paperdetail_receiveinfo_item);
    }

    protected void convert(BaseViewHolder helper, ListModel item) {
        int itemType = item.getItemType();
        if (itemType == 1) {
            ListItem packetItem = item.getListItem();
            this.convertList(helper, packetItem);
        } else if (itemType == 2) {
            SendInfoItem sendInfoItem = item.getSendInfoItem();
            this.convertSendInfo(helper, sendInfoItem);
        } else if (itemType == 3) {
            FooterItem footerItem = item.getFooterItem();
            this.convertFooter(helper, footerItem);
        } else if (itemType == 4) {
            ReceiveInfoItem receiveInfoItem = item.getReceiveInfoItem();
            this.convertReceiveInfo(helper, receiveInfoItem);
        }
    }

    private void convertReceiveInfo(BaseViewHolder helper, ReceiveInfoItem item) {
        TextView tv_money = (TextView)helper.getView(R.id.tv_money);
        tv_money.setText((CharSequence)item.getInfo());
        TextView tv_tipInfo = (TextView)helper.getView(R.id.tv_tipInfo);
        tv_tipInfo.setOnClickListener(view -> {
            Context context;
            if (ClickUtils.isViewSingleClick((View)view) && (context = view.getContext()) instanceof Activity) {
                Activity activity = (Activity)context;
                WalletActivity.start(activity);
            }
        });
    }

    private void convertFooter(BaseViewHolder helper, FooterItem item) {
        TextView tv_info = (TextView)helper.getView(R.id.tv_info);
        tv_info.setText((CharSequence)item.getInfo());
    }

    private void convertSendInfo(BaseViewHolder helper, SendInfoItem item) {
        TextView tv_info = (TextView)helper.getView(R.id.tv_info);
        tv_info.setText((CharSequence)item.getInfo());
    }

    private void convertList(BaseViewHolder helper, ListItem item) {
        TioImageView iv_avatar = (TioImageView)helper.getView(R.id.iv_avatar);
        iv_avatar.loadUrlStatic_radius(item.getAvatar(), 4.0f);
        TextView tv_name = (TextView)helper.getView(R.id.tv_name);
        tv_name.setText((CharSequence)item.getName());
        TextView tv_moneyInfo = (TextView)helper.getView(R.id.tv_moneyInfo);
        tv_moneyInfo.setText((CharSequence)item.getMoneyInfo());
        TextView tv_time = (TextView)helper.getView(R.id.tv_time);
        tv_time.setText((CharSequence)item.getTimeInfo());
        TextView tv_bestLucky = (TextView)helper.getView(R.id.tv_bestLucky);
        tv_bestLucky.setVisibility(item.isBestLucky() ? 0 : 8);
    }
}

