/*
 * Decompiled with CFR 0.152.
 */
package com.watayouxiang.wallet.feature.paperdetail;

import androidx.lifecycle.ViewModel;
import com.blankj.utilcode.util.StringUtils;
import com.blankj.utilcode.util.ThreadUtils;
import com.blankj.utilcode.util.TimeUtils;
import com.watayouxiang.androidutils.widget.TioToast;
import com.watayouxiang.db.prefernces.TioDBPreferences;
import com.watayouxiang.httpclient.callback.TioCallback;
import com.watayouxiang.httpclient.model.request.PayRedInfoReq;
import com.watayouxiang.httpclient.model.response.PayRedInfoResp;
import com.watayouxiang.httpclient.preferences.HttpCache;
import com.watayouxiang.wallet.feature.paperdetail.PaperDetailActivity;
import com.watayouxiang.wallet.feature.paperdetail.adapter.FooterItem;
import com.watayouxiang.wallet.feature.paperdetail.adapter.ListItem;
import com.watayouxiang.wallet.feature.paperdetail.adapter.ListModel;
import com.watayouxiang.wallet.feature.paperdetail.adapter.ReceiveInfoItem;
import com.watayouxiang.wallet.feature.paperdetail.adapter.SendInfoItem;
import com.watayouxiang.wallet.tools.MoneyUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class PaperDetailViewModel
extends ViewModel {
    public void refresh(PaperDetailActivity activity) {
        this.getRedInfo(activity);
    }

    private void getRedInfo(final PaperDetailActivity activity) {
        PayRedInfoReq payRedInfoReq = new PayRedInfoReq(activity.getSerialNumber());
        payRedInfoReq.setCancelTag((Object)activity);
        payRedInfoReq.get((TioCallback)new TioCallback<PayRedInfoResp>(){

            public void onTioSuccess(PayRedInfoResp payRedInfoResp) {
                PayRedInfoResp.InfoBean info = payRedInfoResp.getInfo();
                activity.onRedInfoResp(info);
                PaperDetailViewModel.this.onRedInfoResp(payRedInfoResp, activity);
            }

            public void onTioError(String msg) {
                TioToast.showShort((CharSequence)msg);
            }
        });
    }

    private void onRedInfoResp(final PayRedInfoResp resp, final PaperDetailActivity activity) {
        ThreadUtils.executeByCached((ThreadUtils.Task)new ThreadUtils.SimpleTask<List<ListModel>>(){

            public List<ListModel> doInBackground() throws Throwable {
                return PaperDetailViewModel.this.getListModelsInternal(resp);
            }

            public void onSuccess(List<ListModel> result) {
                activity.setRefreshData(result);
            }
        });
    }

    private List<ListModel> getListModelsInternal(PayRedInfoResp resp) {
        PayRedInfoResp.InfoBean info = resp.getInfo();
        List grabList = resp.getGrablist();
        long currUid = TioDBPreferences.getCurrUid();
        boolean isRedSender = (long)info.getUid() == currUid;
        int receivedCount = grabList.size();
        String status = info.getStatus();
        boolean isPinRed = info.getMode() == 2;
        boolean isGroupSession = info.getChatmode() == 2;
        PayRedInfoResp.GrablistBean currGetRedUser = null;
        long receivedAmount = 0L;
        PayRedInfoResp.GrablistBean bestLuckyUser = null;
        for (int i = 0; i < receivedCount; ++i) {
            PayRedInfoResp.GrablistBean bean = (PayRedInfoResp.GrablistBean)grabList.get(i);
            if ((long)bean.getUid() == currUid) {
                currGetRedUser = bean;
            }
            if (isPinRed && "SUCCESS".equals(status)) {
                if (bestLuckyUser == null) {
                    bestLuckyUser = bean;
                } else {
                    int lucky_amount = bestLuckyUser.getAmount();
                    int curr_amount = bean.getAmount();
                    if (curr_amount >= lucky_amount) {
                        bestLuckyUser = bean;
                    }
                }
            }
            receivedAmount += (long)bean.getAmount();
        }
        String totalAmountStr = MoneyUtils.fen2yuan(String.valueOf(info.getAmount()));
        String receivedAmountStr = MoneyUtils.fen2yuan(String.valueOf(receivedAmount));
        int totalCount = info.getPacketcount();
        String completeTime = info.getBizcompletetime();
        String createTime = info.getBizcreattime();
        ArrayList<ListModel> models = new ArrayList<ListModel>();
        if (currGetRedUser != null) {
            String getRedMoney = MoneyUtils.fen2yuan(String.valueOf(currGetRedUser.getAmount()));
            ReceiveInfoItem receiveInfoItem = new ReceiveInfoItem(getRedMoney);
            models.add(new ListModel(receiveInfoItem));
        }
        String sendInfo = null;
        if ("SUCCESS".equals(status)) {
            if (isGroupSession) {
                String fitTimeSpan = "\u672a\u77e5\u65f6\u95f4";
                try {
                    fitTimeSpan = TimeUtils.getFitTimeSpan((String)completeTime, (String)createTime, (int)4);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                sendInfo = String.format(Locale.getDefault(), "%s\u4e2a\u7ea2\u5305\u5171%s\u5143\uff0c%s\u88ab\u9886\u5b8c", totalCount, totalAmountStr, fitTimeSpan);
            } else if (isRedSender) {
                sendInfo = String.format(Locale.getDefault(), "\u7ea2\u5305\u91d1\u989d%s\u5143\uff0c\u8be5\u7ea2\u5305\u5df2\u9886\u53d6", totalAmountStr);
            }
        } else if ("TIMEOUT".equals(status)) {
            sendInfo = isGroupSession ? String.format(Locale.getDefault(), "\u8be5\u7ea2\u5305\u5df2\u8fc7\u671f\u3002\u5df2\u9886\u53d6%s/%s\u4e2a\uff0c\u5171%s/%s\u5143", receivedCount, totalCount, receivedAmountStr, totalAmountStr) : String.format(Locale.getDefault(), "\u7ea2\u5305\u91d1\u989d%s\u5143\uff0c\u8be5\u7ea2\u5305\u5df2\u8fc7\u671f", totalAmountStr);
        } else if ("SEND".equals(status)) {
            sendInfo = isGroupSession ? String.format(Locale.getDefault(), "\u5df2\u9886\u53d6%s/%s\u4e2a\uff0c\u5171%s/%s\u5143", receivedCount, totalCount, receivedAmountStr, totalAmountStr) : String.format(Locale.getDefault(), "\u7ea2\u5305\u91d1\u989d%s\u5143\uff0c\u7b49\u5f85\u5bf9\u65b9\u9886\u53d6", totalAmountStr);
        }
        if (sendInfo != null) {
            SendInfoItem sendInfoItem = new SendInfoItem(sendInfo);
            models.add(new ListModel(sendInfoItem));
        }
        for (int i = 0; i < receivedCount; ++i) {
            PayRedInfoResp.GrablistBean bean = (PayRedInfoResp.GrablistBean)grabList.get(i);
            ListItem listItem = new ListItem();
            listItem.setAvatar(HttpCache.getResUrl((String)bean.getAvatar()));
            listItem.setName(StringUtils.null2Length0((String)bean.getNick()));
            listItem.setMoneyInfo(MoneyUtils.fen2yuan(String.valueOf(bean.getAmount())) + "\u5143");
            listItem.setTimeInfo(StringUtils.null2Length0((String)bean.getBizcompletetime()));
            if (bestLuckyUser != null) {
                listItem.setBestLucky(bestLuckyUser.getUid() == bean.getUid());
            } else {
                listItem.setBestLucky(false);
            }
            models.add(new ListModel(listItem));
        }
        FooterItem footerItem = null;
        if (isRedSender) {
            if ("TIMEOUT".equals(status)) {
                footerItem = new FooterItem("\u672a\u9886\u53d6\u7684\u7ea2\u5305\u8fc7\u671f\u540e\u81ea\u52a8\u9000\u56de");
            } else if ("SEND".equals(status)) {
                footerItem = new FooterItem("\u672a\u9886\u53d6\u7684\u7ea2\u5305\uff0c\u5c06\u572824\u5c0f\u65f6\u540e\u81ea\u52a8\u9000\u56de");
            }
        }
        if (footerItem != null) {
            models.add(new ListModel(footerItem));
        }
        return models;
    }
}

