/*
 * Decompiled with CFR 0.152.
 */
package com.watayouxiang.wallet.feature.paperdetail;

import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.databinding.ObservableField;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.blankj.utilcode.util.ResourceUtils;
import com.blankj.utilcode.util.StringUtils;
import com.watayouxiang.androidutils.page.BindingDarkActivity;
import com.watayouxiang.androidutils.utils.ClickUtils;
import com.watayouxiang.httpclient.model.response.PayRedInfoResp;
import com.watayouxiang.httpclient.preferences.HttpCache;
import com.watayouxiang.wallet.R;
import com.watayouxiang.wallet.databinding.WalletPaperdetailActivityBinding;
import com.watayouxiang.wallet.feature.paperdetail.PaperDetailViewModel;
import com.watayouxiang.wallet.feature.paperdetail.adapter.ListAdapter;
import com.watayouxiang.wallet.feature.paperdetail.adapter.ListModel;
import com.watayouxiang.wallet.feature.redpacket.RedPacketActivity;
import java.util.List;
import java.util.Locale;

public class PaperDetailActivity
extends BindingDarkActivity<WalletPaperdetailActivityBinding> {
    public final ObservableField<String> fromInfo = new ObservableField((Object)"\u5c0f\u751f\u7684\u7ea2\u5305");
    public final ObservableField<String> giftInfo = new ObservableField((Object)"\u606d\u559c\u53d1\u8d22\uff0c\u5927\u5409\u5927\u5229");
    private ListAdapter listAdapter;
    private static final String KEY_SERIAL_NUMBER = "key_serial_Number";
    private PaperDetailViewModel viewModel;

    public static void start(Context context, String serialNumber) {
        Intent starter = new Intent(context, PaperDetailActivity.class);
        starter.putExtra(KEY_SERIAL_NUMBER, serialNumber);
        context.startActivity(starter);
    }

    public String getSerialNumber() {
        return this.getIntent().getStringExtra(KEY_SERIAL_NUMBER);
    }

    protected Integer background_color() {
        return -1;
    }

    @NonNull
    protected View statusBar_holder() {
        return ((WalletPaperdetailActivityBinding)this.binding).statusBar;
    }

    protected int getContentViewId() {
        return R.layout.wallet_paperdetail_activity;
    }

    public Integer statusBar_color() {
        return this.getResources().getColor(R.color.red_ff5e5e);
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ((WalletPaperdetailActivityBinding)this.binding).setVm(this);
        this.viewModel = (PaperDetailViewModel)this.newViewModel(PaperDetailViewModel.class);
        this.resetUI();
        this.viewModel.refresh(this);
    }

    private void resetUI() {
        ((WalletPaperdetailActivityBinding)this.binding).titleBar.getTvRight().setOnClickListener(view -> {
            if (ClickUtils.isViewSingleClick((View)view)) {
                RedPacketActivity.start((Context)this);
            }
        });
        ((WalletPaperdetailActivityBinding)this.binding).ivAvatar.loadUrlStatic_radius(null, 2.0f);
        this.setPinDrawableVisibility(false);
        this.fromInfo.set((Object)"");
        this.giftInfo.set((Object)"");
        ((WalletPaperdetailActivityBinding)this.binding).recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.listAdapter = new ListAdapter(null);
        ((WalletPaperdetailActivityBinding)this.binding).recyclerView.setAdapter((RecyclerView.Adapter)this.listAdapter);
    }

    private void setPinDrawableVisibility(boolean visibility) {
        if (visibility) {
            Drawable drawable2 = ResourceUtils.getDrawable((int)R.drawable.wallet_ic_pin_19);
            drawable2.setBounds(0, 0, drawable2.getMinimumWidth(), drawable2.getMinimumHeight());
            ((WalletPaperdetailActivityBinding)this.binding).tvFromInfo.setCompoundDrawables(null, null, drawable2, null);
        } else {
            ((WalletPaperdetailActivityBinding)this.binding).tvFromInfo.setCompoundDrawables(null, null, null, null);
        }
    }

    public void setRefreshData(List<ListModel> models) {
        this.listAdapter.setNewData(models);
    }

    public void onRedInfoResp(PayRedInfoResp.InfoBean info) {
        String nick = info.getNick();
        String remark = info.getRemark();
        String avatar = info.getAvatar();
        avatar = HttpCache.getResUrl((String)avatar);
        boolean isPinRed = info.getMode() == 2;
        ((WalletPaperdetailActivityBinding)this.binding).ivAvatar.loadUrlStatic_radius(avatar, 2.0f);
        this.fromInfo.set((Object)String.format(Locale.getDefault(), "%s\u7684\u7ea2\u5305", nick));
        this.giftInfo.set((Object)StringUtils.null2Length0((String)remark));
        this.setPinDrawableVisibility(isPinRed);
    }
}

