/*
 * Decompiled with CFR 0.152.
 */
package com.watayouxiang.wallet.feature.open;

import android.app.Activity;
import androidx.lifecycle.ViewModel;
import com.blankj.utilcode.util.ToastUtils;
import com.watayouxiang.androidutils.widget.TioToast;
import com.watayouxiang.httpclient.callback.TioCallback;
import com.watayouxiang.httpclient.model.request.PayOpenReq;
import com.watayouxiang.httpclient.model.request.UserCurrReq;
import com.watayouxiang.httpclient.model.response.PayOpenResp;
import com.watayouxiang.httpclient.model.response.UserCurrResp;
import com.watayouxiang.wallet.feature.open.OpenWalletActivity;
import com.watayouxiang.wallet.feature.wallet.WalletActivity;

public class OpenWalletViewModel
extends ViewModel {
    public void reqOpenWallet(final OpenWalletActivity activity) {
        String name = (String)activity.userName.get();
        String cardNo = (String)activity.userId.get();
        String phone = (String)activity.userPhone.get();
        PayOpenReq payOpenReq = new PayOpenReq(name, cardNo, phone);
        payOpenReq.setCancelTag((Object)activity);
        payOpenReq.post((TioCallback)new TioCallback<PayOpenResp>(){

            public void onTioSuccess(PayOpenResp payOpenResp) {
                WalletActivity.start((Activity)activity);
                activity.finish();
            }

            public void onTioError(String msg) {
                ToastUtils.showShort((CharSequence)msg);
            }
        });
    }

    public void queryUserPhone(final OpenWalletActivity activity) {
        new UserCurrReq().setCancelTag((Object)activity).get((TioCallback)new TioCallback<UserCurrResp>(){

            public void onTioSuccess(UserCurrResp resp) {
                String phone = resp.phone;
                activity.onUserPhone(phone);
            }

            public void onTioError(String msg) {
                TioToast.showShort((CharSequence)msg);
            }
        });
    }
}

