/*
 * Decompiled with CFR 0.152.
 */
package com.watayouxiang.wallet.feature.bill.fragment.mvp;

import com.watayouxiang.androidutils.widget.TioToast;
import com.watayouxiang.httpclient.callback.TioCallback;
import com.watayouxiang.httpclient.model.response.PayGetWalletItemsResp;
import com.watayouxiang.wallet.feature.bill.fragment.BillVo;
import com.watayouxiang.wallet.feature.bill.fragment.adapter.BillItem;
import com.watayouxiang.wallet.feature.bill.fragment.adapter.BillModel;
import com.watayouxiang.wallet.feature.bill.fragment.mvp.Contract;
import com.watayouxiang.wallet.feature.bill.fragment.mvp.Model;
import java.util.ArrayList;
import java.util.List;

public class Presenter
extends Contract.Presenter {
    private int pageNumber;

    public Presenter(Contract.View view) {
        super(new Model(), view, false);
    }

    @Override
    public void init() {
        ((Contract.View)this.getView()).resetUI();
        this.refreshData();
    }

    @Override
    public void refreshData() {
        this.getWalletItems(1);
    }

    @Override
    public void loadMoreData() {
        this.getWalletItems(++this.pageNumber);
    }

    private void getWalletItems(final int pageNumber) {
        this.pageNumber = pageNumber;
        BillVo billVo = ((Contract.View)this.getView()).getBillVo();
        ((Contract.Model)this.getModel()).getWalletItems(billVo.mode, pageNumber + "", new TioCallback<PayGetWalletItemsResp>(){

            public void onTioSuccess(PayGetWalletItemsResp resp) {
                List list = resp.getList();
                boolean firstPage = resp.isFirstPage();
                boolean lastPage = resp.isLastPage();
                ArrayList models = Presenter.this.getBillModels(list);
                if (firstPage) {
                    ((Contract.View)Presenter.this.getView()).setRefreshData(true, models);
                    if (lastPage) {
                        ((Contract.View)Presenter.this.getView()).setLoadMoreData(true, true, null);
                    }
                } else {
                    ((Contract.View)Presenter.this.getView()).setLoadMoreData(true, lastPage, models);
                }
            }

            public void onTioError(String msg) {
                TioToast.showShort((CharSequence)msg);
                if (pageNumber <= 1) {
                    ((Contract.View)Presenter.this.getView()).setRefreshData(false, null);
                } else {
                    ((Contract.View)Presenter.this.getView()).setLoadMoreData(false, false, null);
                }
            }
        });
    }

    private ArrayList<BillModel> getBillModels(List<PayGetWalletItemsResp.ListBean> list) {
        if (list == null) {
            return new ArrayList<BillModel>();
        }
        int size = list.size();
        ArrayList<BillModel> models = new ArrayList<BillModel>();
        for (int i = 0; i < size; ++i) {
            PayGetWalletItemsResp.ListBean bean = list.get(i);
            BillItem item = new BillItem();
            item.setTitle(bean.getBizstr());
            item.setSubtitle(bean.getBizcreattime());
            item.setRightTitle(bean);
            item.setRightSubtitle(bean);
            item.setRightTitleTextColor(bean);
            models.add(new BillModel(item, bean));
        }
        return models;
    }
}

