/*
 * Decompiled with CFR 0.152.
 */
package com.watayouxiang.wallet.feature.bill.fragment;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.blankj.utilcode.util.CollectionUtils;
import com.watayouxiang.androidutils.page.TioFragment;
import com.watayouxiang.androidutils.utils.ClickUtils;
import com.watayouxiang.httpclient.model.response.PayGetWalletItemsResp;
import com.watayouxiang.wallet.R;
import com.watayouxiang.wallet.databinding.WalletBillFragmentBinding;
import com.watayouxiang.wallet.feature.bill.fragment.BillVo;
import com.watayouxiang.wallet.feature.bill.fragment.adapter.BillListAdapter;
import com.watayouxiang.wallet.feature.bill.fragment.adapter.BillModel;
import com.watayouxiang.wallet.feature.bill.fragment.mvp.Contract;
import com.watayouxiang.wallet.feature.bill.fragment.mvp.Presenter;
import com.watayouxiang.wallet.feature.bill_detail.BillDetailActivity;
import com.watayouxiang.wallet.feature.bill_detail.BillDetailVo;
import java.io.Serializable;
import java.util.List;

public class BillFragment
extends TioFragment
implements Contract.View {
    private static final String KEY_BILL_VO = "KEY_BILL_VO";
    private WalletBillFragmentBinding binding;
    private BillListAdapter billListAdapter;
    private Presenter presenter;

    public static BillFragment newInstance(BillVo billVo) {
        BillFragment fragment = new BillFragment();
        Bundle bundle = new Bundle();
        bundle.putSerializable(KEY_BILL_VO, (Serializable)billVo);
        fragment.setArguments(bundle);
        return fragment;
    }

    @Override
    public BillVo getBillVo() {
        return (BillVo)this.getArguments().getSerializable(KEY_BILL_VO);
    }

    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.binding = WalletBillFragmentBinding.inflate(inflater, container, false);
        return this.binding.getRoot();
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.presenter = new Presenter(this);
        this.presenter.init();
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.presenter.detachView();
    }

    @Override
    public void setRefreshData(boolean ok, List<BillModel> models) {
        if (ok) {
            this.billListAdapter.setNewData(models);
            if (CollectionUtils.isEmpty(models)) {
                View notDataView = this.getLayoutInflater().inflate(R.layout.wallet_bill_list_empty, (ViewGroup)this.binding.recyclerView.getParent(), false);
                this.billListAdapter.setEmptyView(notDataView);
            }
        }
        this.binding.swipeRefreshLayout.setRefreshing(false);
    }

    @Override
    public void setLoadMoreData(boolean ok, boolean lastPage, List<BillModel> models) {
        if (ok) {
            if (models != null) {
                this.billListAdapter.addData(models);
            }
            if (lastPage) {
                this.billListAdapter.loadMoreEnd();
            } else {
                this.billListAdapter.loadMoreComplete();
            }
        } else {
            this.billListAdapter.loadMoreFail();
        }
    }

    @Override
    public void resetUI() {
        this.binding.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.billListAdapter = new BillListAdapter(null);
        this.billListAdapter.setOnLoadMoreListener(() -> this.presenter.loadMoreData(), this.binding.recyclerView);
        this.billListAdapter.setOnItemClickListener((adapter, view, position) -> {
            if (ClickUtils.isViewSingleClick((View)view)) {
                PayGetWalletItemsResp.ListBean original = ((BillModel)this.billListAdapter.getData().get(position)).getOriginal();
                BillDetailVo billDetailVo = BillDetailVo.getInstance(original);
                BillDetailActivity.start((Context)this.getTioActivity(), billDetailVo);
            }
        });
        this.binding.recyclerView.setAdapter((RecyclerView.Adapter)this.billListAdapter);
        this.binding.swipeRefreshLayout.setOnRefreshListener(() -> this.presenter.refreshData());
    }
}

