/*
 * Decompiled with CFR 0.152.
 */
package com.watayouxiang.wallet.feature.account;

import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.databinding.ObservableField;
import com.watayouxiang.androidutils.page.BindingLightActivity;
import com.watayouxiang.httpclient.model.response.PayGetWalletInfoResp;
import com.watayouxiang.wallet.R;
import com.watayouxiang.wallet.databinding.WalletAccountActivityBinding;
import com.watayouxiang.wallet.feature.account.mvp.Contract;
import com.watayouxiang.wallet.feature.account.mvp.Presenter;

public class AccountActivity
extends BindingLightActivity<WalletAccountActivityBinding>
implements Contract.View {
    public final ObservableField<Boolean> idCardStatus = new ObservableField();
    public final ObservableField<Boolean> phoneStatus = new ObservableField();
    public final ObservableField<String> name = new ObservableField((Object)"");
    public final ObservableField<String> idCard = new ObservableField((Object)"");
    public final ObservableField<String> phone = new ObservableField((Object)"");
    private Presenter presenter;

    public static void start(Context context) {
        Intent starter = new Intent(context, AccountActivity.class);
        context.startActivity(starter);
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ((WalletAccountActivityBinding)this.binding).setData(this);
        this.presenter = new Presenter(this);
        this.presenter.init();
    }

    public void onResume(int count) {
        super.onResume(count);
        if (count > 1) {
            this.presenter.getWalletInfo();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.presenter.detachView();
    }

    protected Integer background_color() {
        return Color.parseColor((String)"#F8F8F8");
    }

    @NonNull
    protected View statusBar_holder() {
        return ((WalletAccountActivityBinding)this.binding).statusBar;
    }

    protected int getContentViewId() {
        return R.layout.wallet_account_activity;
    }

    @Override
    public void onWalletInfoResp(PayGetWalletInfoResp resp) {
        ((WalletAccountActivityBinding)this.binding).tvNameMark.setVisibility(0);
        ((WalletAccountActivityBinding)this.binding).tvPhoneMark.setVisibility(0);
        this.name.set((Object)resp.getNameDesc());
        this.idCard.set((Object)resp.getIdCardNoDesc());
        this.phone.set((Object)resp.getMobileDesc());
        this.idCardStatus.set((Object)"SUCCESS".equals(resp.getIdCardRzStatus()));
        this.phoneStatus.set((Object)"SUCCESS".equals(resp.getOperatorRzStatus()));
    }

    @Override
    public void resetUI() {
        ((WalletAccountActivityBinding)this.binding).tvNameMark.setVisibility(4);
        ((WalletAccountActivityBinding)this.binding).tvPhoneMark.setVisibility(4);
        this.idCardStatus.set((Object)false);
        this.phoneStatus.set((Object)false);
        this.name.set((Object)"");
        this.idCard.set((Object)"");
        this.phone.set((Object)"");
    }
}

