/*
 * Decompiled with CFR 0.152.
 */
package com.vbytsyuk.ahbottomnavigation.notification;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;

public class AHNotification
implements Parcelable {
    @Nullable
    private String text;
    @ColorInt
    private int textColor;
    @ColorInt
    private int backgroundColor;
    public static final Parcelable.Creator<AHNotification> CREATOR = new Parcelable.Creator<AHNotification>(){

        public AHNotification createFromParcel(Parcel in) {
            return new AHNotification(in);
        }

        public AHNotification[] newArray(int size) {
            return new AHNotification[size];
        }
    };

    public AHNotification() {
    }

    private AHNotification(Parcel in) {
        this.text = in.readString();
        this.textColor = in.readInt();
        this.backgroundColor = in.readInt();
    }

    public boolean isEmpty() {
        return TextUtils.isEmpty((CharSequence)this.text);
    }

    public String getText() {
        return this.text;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public static AHNotification justText(String text) {
        return new Builder().setText(text).build();
    }

    public static List<AHNotification> generateEmptyList(int size) {
        ArrayList<AHNotification> notificationList = new ArrayList<AHNotification>();
        for (int i = 0; i < size; ++i) {
            notificationList.add(new AHNotification());
        }
        return notificationList;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.text);
        dest.writeInt(this.textColor);
        dest.writeInt(this.backgroundColor);
    }

    public static class Builder {
        @Nullable
        private String text;
        @ColorInt
        private int textColor;
        @ColorInt
        private int backgroundColor;

        public Builder setText(String text) {
            this.text = text;
            return this;
        }

        public Builder setTextColor(@ColorInt int textColor) {
            this.textColor = textColor;
            return this;
        }

        public Builder setBackgroundColor(@ColorInt int backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public AHNotification build() {
            AHNotification notification = new AHNotification();
            notification.text = this.text;
            notification.textColor = this.textColor;
            notification.backgroundColor = this.backgroundColor;
            return notification;
        }
    }
}

