/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.zjsonpatch.mapping.jackson3;

import com.flipkart.zjsonpatch.mapping.ArrayNodeWrapper;
import com.flipkart.zjsonpatch.mapping.IteratorDecorator;
import com.flipkart.zjsonpatch.mapping.JsonNodeWrapper;
import com.flipkart.zjsonpatch.mapping.JsonTokenWrapper;
import com.flipkart.zjsonpatch.mapping.ObjectNodeWrapper;
import com.flipkart.zjsonpatch.mapping.jackson3.Jackson3ArrayNodeWrapper;
import com.flipkart.zjsonpatch.mapping.jackson3.Jackson3ObjectNodeWrapper;
import java.util.Collections;
import java.util.Iterator;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ObjectNode;

public class Jackson3NodeWrapper
implements JsonNodeWrapper {
    private final JsonNode node;

    public Jackson3NodeWrapper(JsonNode node) {
        this.node = node;
    }

    @Override
    public boolean isArray() {
        return this.node.isArray();
    }

    @Override
    public boolean isObject() {
        return this.node.isObject();
    }

    @Override
    public boolean isTextual() {
        return this.node.isString();
    }

    @Override
    public boolean isNumber() {
        return this.node.isNumber();
    }

    @Override
    public boolean isBoolean() {
        return this.node.isBoolean();
    }

    @Override
    public boolean isNull() {
        return this.node.isNull();
    }

    @Override
    public boolean isContainerNode() {
        return this.node.isArray() || this.node.isObject();
    }

    @Override
    public JsonNodeWrapper get(String fieldName) {
        JsonNode result = this.node.get(fieldName);
        return result != null ? new Jackson3NodeWrapper(result) : null;
    }

    @Override
    public JsonNodeWrapper get(int index) {
        JsonNode result = this.node.get(index);
        return result != null ? new Jackson3NodeWrapper(result) : null;
    }

    @Override
    public boolean has(String fieldName) {
        return this.node.has(fieldName);
    }

    @Override
    public String textValue() {
        return this.node.stringValue();
    }

    @Override
    public int size() {
        return this.node.size();
    }

    @Override
    public Iterator<String> fieldNames() {
        if (this.node.isObject()) {
            return this.node.propertyNames().iterator();
        }
        return Collections.emptyIterator();
    }

    @Override
    public Iterator<JsonNodeWrapper> iterator() {
        return new IteratorDecorator(this.node.iterator());
    }

    @Override
    public ArrayNodeWrapper arrayValue() {
        if (this.node.isArray()) {
            return new Jackson3ArrayNodeWrapper((ArrayNode)this.node);
        }
        return null;
    }

    @Override
    public ObjectNodeWrapper objectValue() {
        if (this.node.isObject()) {
            return new Jackson3ObjectNodeWrapper((ObjectNode)this.node);
        }
        return null;
    }

    @Override
    public JsonNodeWrapper deepCopy() {
        return new Jackson3NodeWrapper(this.node.deepCopy());
    }

    @Override
    public JsonTokenWrapper asToken() {
        return this.mapToken(this.node.asToken());
    }

    private JsonTokenWrapper mapToken(JsonToken token) {
        if (token == null) {
            return null;
        }
        if (token == JsonToken.START_OBJECT) {
            return JsonTokenWrapper.START_OBJECT;
        }
        if (token == JsonToken.START_ARRAY) {
            return JsonTokenWrapper.START_ARRAY;
        }
        if (token == JsonToken.VALUE_STRING) {
            return JsonTokenWrapper.VALUE_STRING;
        }
        if (token == JsonToken.VALUE_NUMBER_INT) {
            return JsonTokenWrapper.VALUE_NUMBER_INT;
        }
        if (token == JsonToken.VALUE_NUMBER_FLOAT) {
            return JsonTokenWrapper.VALUE_NUMBER_FLOAT;
        }
        if (token == JsonToken.VALUE_TRUE) {
            return JsonTokenWrapper.VALUE_TRUE;
        }
        if (token == JsonToken.VALUE_FALSE) {
            return JsonTokenWrapper.VALUE_FALSE;
        }
        if (token == JsonToken.VALUE_NULL) {
            return JsonTokenWrapper.VALUE_NULL;
        }
        return null;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Jackson3NodeWrapper) {
            return this.node.equals((Object)((Jackson3NodeWrapper)other).node);
        }
        return false;
    }

    public int hashCode() {
        return this.node.hashCode();
    }

    @Override
    public String toString() {
        return this.node.toString();
    }

    @Override
    public Object getUnderlyingNode() {
        return this.node;
    }

    public JsonNode getJackson3Node() {
        return this.node;
    }
}

