/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.zjsonpatch.mapping.jackson2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.flipkart.zjsonpatch.mapping.IteratorDecorator;
import com.flipkart.zjsonpatch.mapping.JsonNodeWrapper;
import com.flipkart.zjsonpatch.mapping.ObjectNodeWrapper;
import com.flipkart.zjsonpatch.mapping.jackson2.Jackson2NodeWrapper;
import java.util.Iterator;

public class Jackson2ObjectNodeWrapper
extends Jackson2NodeWrapper
implements ObjectNodeWrapper {
    private final ObjectNode objectNode;

    public Jackson2ObjectNodeWrapper(ObjectNode objectNode) {
        super((JsonNode)objectNode);
        this.objectNode = objectNode;
    }

    @Override
    public JsonNodeWrapper put(String fieldName, JsonNodeWrapper value) {
        if (value == null) {
            this.objectNode.putNull(fieldName);
            return this;
        }
        Jackson2NodeWrapper jackson2Value = (Jackson2NodeWrapper)value;
        this.objectNode.put(fieldName, jackson2Value.getJackson2Node());
        return this;
    }

    @Override
    public JsonNodeWrapper set(String fieldName, JsonNodeWrapper value) {
        if (value == null) {
            this.objectNode.set(fieldName, null);
            return this;
        }
        Jackson2NodeWrapper jackson2Value = (Jackson2NodeWrapper)value;
        this.objectNode.set(fieldName, jackson2Value.getJackson2Node());
        return this;
    }

    @Override
    public JsonNodeWrapper replace(String fieldName, JsonNodeWrapper value) {
        if (value == null) {
            JsonNode result = this.objectNode.replace(fieldName, null);
            return result != null ? new Jackson2NodeWrapper(result) : null;
        }
        JsonNode result = this.objectNode.replace(fieldName, ((Jackson2NodeWrapper)value).getJackson2Node());
        return result != null ? new Jackson2NodeWrapper(result) : null;
    }

    @Override
    public JsonNodeWrapper remove(String fieldName) {
        JsonNode result = this.objectNode.remove(fieldName);
        return result != null ? new Jackson2NodeWrapper(result) : null;
    }

    @Override
    public Iterator<JsonNodeWrapper> iterator() {
        return new IteratorDecorator(this.objectNode.iterator());
    }
}

