/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.zjsonpatch.mapping.jackson2;

import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.flipkart.zjsonpatch.mapping.ArrayNodeWrapper;
import com.flipkart.zjsonpatch.mapping.IteratorDecorator;
import com.flipkart.zjsonpatch.mapping.JsonNodeWrapper;
import com.flipkart.zjsonpatch.mapping.JsonTokenWrapper;
import com.flipkart.zjsonpatch.mapping.ObjectNodeWrapper;
import com.flipkart.zjsonpatch.mapping.jackson2.Jackson2ArrayNodeWrapper;
import com.flipkart.zjsonpatch.mapping.jackson2.Jackson2ObjectNodeWrapper;
import java.util.Iterator;

public class Jackson2NodeWrapper
implements JsonNodeWrapper {
    private final JsonNode node;

    public Jackson2NodeWrapper(JsonNode node) {
        this.node = node;
    }

    @Override
    public boolean isArray() {
        return this.node.isArray();
    }

    @Override
    public boolean isObject() {
        return this.node.isObject();
    }

    @Override
    public boolean isTextual() {
        return this.node.isTextual();
    }

    @Override
    public boolean isNumber() {
        return this.node.isNumber();
    }

    @Override
    public boolean isBoolean() {
        return this.node.isBoolean();
    }

    @Override
    public boolean isNull() {
        return this.node.isNull();
    }

    @Override
    public boolean isContainerNode() {
        return this.node.isContainerNode();
    }

    @Override
    public JsonNodeWrapper get(String fieldName) {
        JsonNode result = this.node.get(fieldName);
        return result != null ? new Jackson2NodeWrapper(result) : null;
    }

    @Override
    public JsonNodeWrapper get(int index) {
        JsonNode result = this.node.get(index);
        return result != null ? new Jackson2NodeWrapper(result) : null;
    }

    @Override
    public boolean has(String fieldName) {
        return this.node.has(fieldName);
    }

    @Override
    public String textValue() {
        return this.node.textValue();
    }

    @Override
    public int size() {
        return this.node.size();
    }

    @Override
    public Iterator<String> fieldNames() {
        return this.node.fieldNames();
    }

    @Override
    public Iterator<JsonNodeWrapper> iterator() {
        return new IteratorDecorator(this.node.iterator());
    }

    @Override
    public ArrayNodeWrapper arrayValue() {
        if (this.node.isArray()) {
            return new Jackson2ArrayNodeWrapper((ArrayNode)this.node);
        }
        return null;
    }

    @Override
    public ObjectNodeWrapper objectValue() {
        if (this.node.isObject()) {
            return new Jackson2ObjectNodeWrapper((ObjectNode)this.node);
        }
        return null;
    }

    @Override
    public JsonNodeWrapper deepCopy() {
        return new Jackson2NodeWrapper(this.node.deepCopy());
    }

    @Override
    public JsonTokenWrapper asToken() {
        return this.mapToken(this.node.asToken());
    }

    private JsonTokenWrapper mapToken(JsonToken token) {
        if (token == null) {
            return null;
        }
        return switch (token) {
            case JsonToken.START_OBJECT -> JsonTokenWrapper.START_OBJECT;
            case JsonToken.START_ARRAY -> JsonTokenWrapper.START_ARRAY;
            case JsonToken.VALUE_STRING -> JsonTokenWrapper.VALUE_STRING;
            case JsonToken.VALUE_NUMBER_INT -> JsonTokenWrapper.VALUE_NUMBER_INT;
            case JsonToken.VALUE_NUMBER_FLOAT -> JsonTokenWrapper.VALUE_NUMBER_FLOAT;
            case JsonToken.VALUE_TRUE -> JsonTokenWrapper.VALUE_TRUE;
            case JsonToken.VALUE_FALSE -> JsonTokenWrapper.VALUE_FALSE;
            case JsonToken.VALUE_NULL -> JsonTokenWrapper.VALUE_NULL;
            default -> null;
        };
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Jackson2NodeWrapper) {
            return this.node.equals((Object)((Jackson2NodeWrapper)other).node);
        }
        return false;
    }

    public int hashCode() {
        return this.node.hashCode();
    }

    @Override
    public String toString() {
        return this.node.toString();
    }

    @Override
    public Object getUnderlyingNode() {
        return this.node;
    }

    public JsonNode getJackson2Node() {
        return this.node;
    }
}

