/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.zjsonpatch.mapping;

import com.flipkart.zjsonpatch.mapping.JacksonVersionBridge;
import com.flipkart.zjsonpatch.mapping.JsonNodeWrapper;
import java.util.ListIterator;
import java.util.Objects;

public class ListIteratorDecorator<E>
implements ListIterator<JsonNodeWrapper> {
    private final ListIterator<E> iterator;

    public ListIteratorDecorator(ListIterator<E> iterator) {
        this.iterator = Objects.requireNonNull(iterator, "iterator");
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public JsonNodeWrapper next() {
        E next = this.iterator.next();
        return JacksonVersionBridge.wrap(next);
    }

    @Override
    public int nextIndex() {
        return this.iterator.nextIndex();
    }

    @Override
    public boolean hasPrevious() {
        return this.iterator.hasPrevious();
    }

    @Override
    public JsonNodeWrapper previous() {
        E previous = this.iterator.previous();
        return JacksonVersionBridge.wrap(previous);
    }

    @Override
    public int previousIndex() {
        return this.iterator.previousIndex();
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    @Override
    public void set(JsonNodeWrapper obj) {
        this.iterator.set(JacksonVersionBridge.unwrap(obj));
    }

    @Override
    public void add(JsonNodeWrapper obj) {
        this.iterator.add(JacksonVersionBridge.unwrap(obj));
    }
}

