/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.zjsonpatch;

import com.flipkart.zjsonpatch.CompatibilityFlags;
import com.flipkart.zjsonpatch.InvalidJsonPatchException;
import com.flipkart.zjsonpatch.JsonPatchApplicationException;
import com.flipkart.zjsonpatch.JsonPatchProcessor;
import com.flipkart.zjsonpatch.JsonPointer;
import com.flipkart.zjsonpatch.JsonPointerEvaluationException;
import com.flipkart.zjsonpatch.Operation;
import com.flipkart.zjsonpatch.mapping.JsonNodeFactoryWrapper;
import com.flipkart.zjsonpatch.mapping.JsonNodeWrapper;
import java.util.EnumSet;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class AbstractJsonPatch {
    protected AbstractJsonPatch() {
    }

    private static JsonNodeWrapper getPatchStringAttr(JsonNodeWrapper jsonNode, String attr) {
        JsonNodeWrapper child = AbstractJsonPatch.getPatchAttr(jsonNode, attr);
        if (!child.isTextual()) {
            throw new InvalidJsonPatchException("Invalid JSON Patch payload (non-text '" + attr + "' field)");
        }
        return child;
    }

    private static JsonNodeWrapper getPatchAttr(JsonNodeWrapper jsonNode, String attr) {
        JsonNodeWrapper child = jsonNode.get(attr);
        if (child == null) {
            throw new InvalidJsonPatchException("Invalid JSON Patch payload (missing '" + attr + "' field)");
        }
        return child;
    }

    private static JsonNodeWrapper getPatchAttrWithDefault(JsonNodeWrapper jsonNode, String attr, JsonNodeWrapper defaultValue) {
        JsonNodeWrapper child = jsonNode.get(attr);
        if (child == null) {
            return defaultValue;
        }
        return child;
    }

    protected static void process(JsonNodeWrapper patch, JsonPatchProcessor processor, EnumSet<CompatibilityFlags> flags, JsonNodeFactoryWrapper factory) throws InvalidJsonPatchException {
        if (!patch.isArray()) {
            throw new InvalidJsonPatchException("Invalid JSON Patch payload (not an array)");
        }
        for (JsonNodeWrapper jsonNode : patch) {
            if (!jsonNode.isObject()) {
                throw new InvalidJsonPatchException("Invalid JSON Patch payload (not an object)");
            }
            Operation operation = Operation.fromRfcName(AbstractJsonPatch.getPatchStringAttr(jsonNode, "op").textValue());
            JsonPointer path = JsonPointer.parse(AbstractJsonPatch.getPatchStringAttr(jsonNode, "path").textValue());
            try {
                switch (operation) {
                    case REMOVE: {
                        processor.remove(path);
                        break;
                    }
                    case ADD: {
                        JsonNodeWrapper value = !flags.contains((Object)CompatibilityFlags.MISSING_VALUES_AS_NULLS) ? AbstractJsonPatch.getPatchAttr(jsonNode, "value") : AbstractJsonPatch.getPatchAttrWithDefault(jsonNode, "value", factory.nullNode());
                        processor.add(path, value.deepCopy());
                        break;
                    }
                    case REPLACE: {
                        JsonNodeWrapper value = !flags.contains((Object)CompatibilityFlags.MISSING_VALUES_AS_NULLS) ? AbstractJsonPatch.getPatchAttr(jsonNode, "value") : AbstractJsonPatch.getPatchAttrWithDefault(jsonNode, "value", factory.nullNode());
                        processor.replace(path, value.deepCopy());
                        break;
                    }
                    case MOVE: {
                        JsonPointer fromPath = JsonPointer.parse(AbstractJsonPatch.getPatchStringAttr(jsonNode, "from").textValue());
                        processor.move(fromPath, path);
                        break;
                    }
                    case COPY: {
                        JsonPointer fromPath = JsonPointer.parse(AbstractJsonPatch.getPatchStringAttr(jsonNode, "from").textValue());
                        processor.copy(fromPath, path);
                        break;
                    }
                    case TEST: {
                        JsonNodeWrapper value = !flags.contains((Object)CompatibilityFlags.MISSING_VALUES_AS_NULLS) ? AbstractJsonPatch.getPatchAttr(jsonNode, "value") : AbstractJsonPatch.getPatchAttrWithDefault(jsonNode, "value", factory.nullNode());
                        processor.test(path, value.deepCopy());
                        break;
                    }
                }
            }
            catch (JsonPointerEvaluationException e) {
                throw new JsonPatchApplicationException(e.getMessage(), operation, e.getPath());
            }
        }
    }
}

