/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.zjsonpatch;

import com.flipkart.zjsonpatch.AbstractJsonPointer;
import com.flipkart.zjsonpatch.Diff;
import com.flipkart.zjsonpatch.DiffFlags;
import com.flipkart.zjsonpatch.InternalUtils;
import com.flipkart.zjsonpatch.NodeType;
import com.flipkart.zjsonpatch.Operation;
import com.flipkart.zjsonpatch.RefToken;
import com.flipkart.zjsonpatch.mapping.ArrayNodeWrapper;
import com.flipkart.zjsonpatch.mapping.JsonNodeFactoryWrapper;
import com.flipkart.zjsonpatch.mapping.JsonNodeWrapper;
import com.flipkart.zjsonpatch.mapping.ObjectNodeWrapper;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.ListUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class AbstractJsonDiff {
    private final List<Diff> diffs = new ArrayList<Diff>();
    private final EnumSet<DiffFlags> flags;

    protected AbstractJsonDiff(EnumSet<DiffFlags> flags) {
        this.flags = flags.clone();
    }

    protected static JsonNodeWrapper getJsonNode(JsonNodeWrapper sourceWrapper, JsonNodeWrapper targetWrapper, AbstractJsonDiff diff, JsonNodeFactoryWrapper factory) {
        if (sourceWrapper == null && targetWrapper != null) {
            diff.diffs.add(Diff.generateDiff(Operation.ADD, diff.getJsonPointerRoot(), targetWrapper));
        }
        if (sourceWrapper != null && targetWrapper == null) {
            diff.diffs.add(Diff.generateDiff(Operation.REMOVE, diff.getJsonPointerRoot(), sourceWrapper));
        }
        if (sourceWrapper != null && targetWrapper != null) {
            diff.generateDiffs(diff.getJsonPointerRoot(), sourceWrapper, targetWrapper);
            if (!diff.flags.contains((Object)DiffFlags.OMIT_MOVE_OPERATION)) {
                diff.introduceMoveOperation();
            }
            if (!diff.flags.contains((Object)DiffFlags.OMIT_COPY_OPERATION)) {
                diff.introduceCopyOperation(sourceWrapper, targetWrapper);
            }
            if (diff.flags.contains((Object)DiffFlags.ADD_EXPLICIT_REMOVE_ADD_ON_REPLACE)) {
                diff.introduceExplicitRemoveAndAddOperation();
            }
        }
        return diff.getJsonNodes(factory);
    }

    protected abstract AbstractJsonPointer getJsonPointerRoot();

    protected abstract AbstractJsonPointer createJsonPointerInstance(List<RefToken> var1);

    private AbstractJsonPointer getMatchingValuePath(Map<JsonNodeWrapper, AbstractJsonPointer> unchangedValues, JsonNodeWrapper value) {
        return unchangedValues.get(value);
    }

    private void introduceCopyOperation(JsonNodeWrapper source, JsonNodeWrapper target) {
        Map<JsonNodeWrapper, AbstractJsonPointer> unchangedValues = this.getUnchangedPart(source, target);
        for (int i = 0; i < this.diffs.size(); ++i) {
            AbstractJsonPointer matchingValuePath;
            Diff diff = this.diffs.get(i);
            if (Operation.ADD != diff.getOperation() || (matchingValuePath = this.getMatchingValuePath(unchangedValues, diff.getValue())) == null || !AbstractJsonDiff.isAllowed(matchingValuePath, diff.getPath())) continue;
            if (this.flags.contains((Object)DiffFlags.EMIT_TEST_OPERATIONS)) {
                this.diffs.add(i, new Diff(Operation.TEST, matchingValuePath, diff.getValue()));
                ++i;
            }
            this.diffs.set(i, new Diff(Operation.COPY, matchingValuePath, diff.getPath()));
        }
    }

    private static boolean isNumber(String str) {
        int size = str.length();
        for (int i = 0; i < size; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return size > 0;
    }

    private static boolean isAllowed(AbstractJsonPointer source, AbstractJsonPointer destination) {
        boolean isSame = source.equals(destination);
        int i = 0;
        for (int j = 0; i < source.size() && j < destination.size(); ++i, ++j) {
            RefToken srcValue = source.get(i);
            RefToken dstValue = destination.get(j);
            String srcStr = srcValue.toString();
            String dstStr = dstValue.toString();
            if (!AbstractJsonDiff.isNumber(srcStr) || !AbstractJsonDiff.isNumber(dstStr) || srcStr.compareTo(dstStr) <= 0) continue;
            return false;
        }
        return !isSame;
    }

    private Map<JsonNodeWrapper, AbstractJsonPointer> getUnchangedPart(JsonNodeWrapper source, JsonNodeWrapper target) {
        HashMap<JsonNodeWrapper, AbstractJsonPointer> unchangedValues = new HashMap<JsonNodeWrapper, AbstractJsonPointer>();
        AbstractJsonDiff.computeUnchangedValues(unchangedValues, this.getJsonPointerRoot(), source, target);
        return unchangedValues;
    }

    private static void computeUnchangedValues(Map<JsonNodeWrapper, AbstractJsonPointer> unchangedValues, AbstractJsonPointer path, JsonNodeWrapper source, JsonNodeWrapper target) {
        NodeType secondType;
        if (source.equals(target)) {
            if (!unchangedValues.containsKey(target)) {
                unchangedValues.put(target, path);
            }
            return;
        }
        NodeType firstType = NodeType.getNodeType(source);
        if (firstType == (secondType = NodeType.getNodeType(target))) {
            switch (firstType) {
                case OBJECT: {
                    AbstractJsonDiff.computeObject(unchangedValues, path, source, target);
                    break;
                }
                case ARRAY: {
                    AbstractJsonDiff.computeArray(unchangedValues, path, source, target);
                    break;
                }
            }
        }
    }

    private static void computeArray(Map<JsonNodeWrapper, AbstractJsonPointer> unchangedValues, AbstractJsonPointer path, JsonNodeWrapper source, JsonNodeWrapper target) {
        int size = Math.min(source.size(), target.size());
        for (int i = 0; i < size; ++i) {
            AbstractJsonPointer currPath = path.append(i);
            AbstractJsonDiff.computeUnchangedValues(unchangedValues, currPath, source.get(i), target.get(i));
        }
    }

    private static void computeObject(Map<JsonNodeWrapper, AbstractJsonPointer> unchangedValues, AbstractJsonPointer path, JsonNodeWrapper source, JsonNodeWrapper target) {
        Iterator<String> firstFields = source.fieldNames();
        while (firstFields.hasNext()) {
            String name = firstFields.next();
            if (!target.has(name)) continue;
            AbstractJsonPointer currPath = path.append(name);
            AbstractJsonDiff.computeUnchangedValues(unchangedValues, currPath, source.get(name), target.get(name));
        }
    }

    private void introduceMoveOperation() {
        block0: for (int i = 0; i < this.diffs.size(); ++i) {
            Diff diff1 = this.diffs.get(i);
            if (Operation.REMOVE != diff1.getOperation() && Operation.ADD != diff1.getOperation()) continue;
            for (int j = i + 1; j < this.diffs.size(); ++j) {
                Diff diff2 = this.diffs.get(j);
                if (!diff1.getValue().equals(diff2.getValue())) continue;
                Diff moveDiff = null;
                if (Operation.REMOVE == diff1.getOperation() && Operation.ADD == diff2.getOperation()) {
                    relativePath = this.computeRelativePath(diff2.getPath(), i + 1, j - 1, this.diffs);
                    moveDiff = new Diff(Operation.MOVE, diff1.getPath(), relativePath);
                } else if (Operation.ADD == diff1.getOperation() && Operation.REMOVE == diff2.getOperation()) {
                    relativePath = this.computeRelativePath(diff2.getPath(), i, j - 1, this.diffs);
                    moveDiff = new Diff(Operation.MOVE, relativePath, diff1.getPath());
                }
                if (moveDiff == null) continue;
                this.diffs.remove(j);
                this.diffs.set(i, moveDiff);
                continue block0;
            }
        }
    }

    private void introduceExplicitRemoveAndAddOperation() {
        ArrayList<Diff> updatedDiffs = new ArrayList<Diff>();
        for (Diff diff : this.diffs) {
            if (!diff.getOperation().equals((Object)Operation.REPLACE) || diff.getSrcValue() == null) {
                updatedDiffs.add(diff);
                continue;
            }
            updatedDiffs.add(new Diff(Operation.REMOVE, diff.getPath(), diff.getSrcValue()));
            updatedDiffs.add(new Diff(Operation.ADD, diff.getPath(), diff.getValue()));
        }
        this.diffs.clear();
        this.diffs.addAll(updatedDiffs);
    }

    private AbstractJsonPointer computeRelativePath(AbstractJsonPointer path, int startIdx, int endIdx, List<Diff> diffs) {
        int i;
        ArrayList<Integer> counters = new ArrayList<Integer>(path.size());
        for (i = 0; i < path.size(); ++i) {
            counters.add(0);
        }
        for (i = startIdx; i <= endIdx; ++i) {
            Diff diff = diffs.get(i);
            if (Operation.ADD != diff.getOperation() && Operation.REMOVE != diff.getOperation()) continue;
            AbstractJsonDiff.updatePath(path, diff, counters);
        }
        return this.updatePathWithCounters(counters, path);
    }

    private AbstractJsonPointer updatePathWithCounters(List<Integer> counters, AbstractJsonPointer path) {
        List<RefToken> tokens = path.decompose();
        for (int i = 0; i < counters.size(); ++i) {
            int value = counters.get(i);
            if (value == 0) continue;
            int currValue = tokens.get(i).getIndex();
            tokens.set(i, RefToken.parse(Integer.toString(currValue + value)));
        }
        return this.createJsonPointerInstance(tokens);
    }

    private static void updatePath(AbstractJsonPointer path, Diff pseudo, List<Integer> counters) {
        if (pseudo.getPath().size() <= path.size()) {
            int idx = -1;
            int i = 0;
            while (i < pseudo.getPath().size() - 1 && pseudo.getPath().get(i).equals(path.get(i))) {
                idx = i++;
            }
            if (idx == pseudo.getPath().size() - 2 && pseudo.getPath().get(pseudo.getPath().size() - 1).isArrayIndex()) {
                AbstractJsonDiff.updateCounters(pseudo, pseudo.getPath().size() - 1, counters);
            }
        }
    }

    private static void updateCounters(Diff pseudo, int idx, List<Integer> counters) {
        if (Operation.ADD == pseudo.getOperation()) {
            counters.set(idx, counters.get(idx) - 1);
        } else if (Operation.REMOVE == pseudo.getOperation()) {
            counters.set(idx, counters.get(idx) + 1);
        }
    }

    private JsonNodeWrapper getJsonNodes(JsonNodeFactoryWrapper factory) {
        ArrayNodeWrapper patch = factory.arrayNode();
        for (Diff diff : this.diffs) {
            ObjectNodeWrapper jsonNode = AbstractJsonDiff.getJsonNode(factory, diff, this.flags);
            patch.add(jsonNode);
        }
        return patch;
    }

    private static ObjectNodeWrapper getJsonNode(JsonNodeFactoryWrapper FACTORY, Diff diff, EnumSet<DiffFlags> flags) {
        ObjectNodeWrapper jsonNode = FACTORY.objectNode();
        jsonNode.put("op", FACTORY.textNode(diff.getOperation().rfcName()));
        switch (diff.getOperation()) {
            case MOVE: 
            case COPY: {
                jsonNode.put("from", FACTORY.textNode(diff.getPath().toString()));
                jsonNode.put("path", FACTORY.textNode(diff.getToPath().toString()));
                break;
            }
            case REMOVE: {
                jsonNode.put("path", FACTORY.textNode(diff.getPath().toString()));
                if (flags.contains((Object)DiffFlags.OMIT_VALUE_ON_REMOVE)) break;
                jsonNode.set("value", diff.getValue());
                break;
            }
            case REPLACE: {
                if (flags.contains((Object)DiffFlags.ADD_ORIGINAL_VALUE_ON_REPLACE)) {
                    jsonNode.set("fromValue", diff.getSrcValue());
                }
            }
            case ADD: 
            case TEST: {
                jsonNode.put("path", FACTORY.textNode(diff.getPath().toString()));
                jsonNode.set("value", diff.getValue());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operation specified:" + String.valueOf((Object)diff.getOperation()));
            }
        }
        return jsonNode;
    }

    private void generateDiffs(AbstractJsonPointer path, JsonNodeWrapper source, JsonNodeWrapper target) {
        if (!source.equals(target)) {
            NodeType sourceType = NodeType.getNodeType(source);
            NodeType targetType = NodeType.getNodeType(target);
            if (sourceType == NodeType.ARRAY && targetType == NodeType.ARRAY) {
                this.compareArray(path, source, target);
            } else if (sourceType == NodeType.OBJECT && targetType == NodeType.OBJECT) {
                this.compareObjects(path, source, target);
            } else {
                if (this.flags.contains((Object)DiffFlags.EMIT_TEST_OPERATIONS)) {
                    this.diffs.add(new Diff(Operation.TEST, path, source));
                }
                this.diffs.add(Diff.generateDiff(Operation.REPLACE, path, source, target));
            }
        }
    }

    private void compareArray(AbstractJsonPointer path, JsonNodeWrapper source, JsonNodeWrapper target) {
        List<JsonNodeWrapper> lcs = AbstractJsonDiff.getLCS(source, target);
        int srcIdx = 0;
        int targetIdx = 0;
        int lcsIdx = 0;
        int srcSize = source.size();
        int targetSize = target.size();
        int lcsSize = lcs.size();
        int pos = 0;
        while (lcsIdx < lcsSize) {
            AbstractJsonPointer currPath;
            JsonNodeWrapper lcsNode = lcs.get(lcsIdx);
            JsonNodeWrapper srcNode = source.get(srcIdx);
            JsonNodeWrapper targetNode = target.get(targetIdx);
            if (lcsNode.equals(srcNode) && lcsNode.equals(targetNode)) {
                ++srcIdx;
                ++targetIdx;
                ++lcsIdx;
                ++pos;
                continue;
            }
            if (lcsNode.equals(srcNode)) {
                currPath = path.append(pos);
                this.diffs.add(Diff.generateDiff(Operation.ADD, currPath, targetNode));
                ++pos;
                ++targetIdx;
                continue;
            }
            if (lcsNode.equals(targetNode)) {
                currPath = path.append(pos);
                if (this.flags.contains((Object)DiffFlags.EMIT_TEST_OPERATIONS)) {
                    this.diffs.add(new Diff(Operation.TEST, currPath, srcNode));
                }
                this.diffs.add(Diff.generateDiff(Operation.REMOVE, currPath, srcNode));
                ++srcIdx;
                continue;
            }
            currPath = path.append(pos);
            this.generateDiffs(currPath, srcNode, targetNode);
            ++srcIdx;
            ++targetIdx;
            ++pos;
        }
        while (srcIdx < srcSize && targetIdx < targetSize) {
            JsonNodeWrapper srcNode = source.get(srcIdx);
            JsonNodeWrapper targetNode = target.get(targetIdx);
            AbstractJsonPointer currPath = path.append(pos);
            this.generateDiffs(currPath, srcNode, targetNode);
            ++srcIdx;
            ++targetIdx;
            ++pos;
        }
        pos = this.addRemaining(path, target, pos, targetIdx, targetSize);
        this.removeRemaining(path, pos, srcIdx, srcSize, source);
    }

    private void removeRemaining(AbstractJsonPointer path, int pos, int srcIdx, int srcSize, JsonNodeWrapper source) {
        while (srcIdx < srcSize) {
            AbstractJsonPointer currPath = path.append(pos);
            if (this.flags.contains((Object)DiffFlags.EMIT_TEST_OPERATIONS)) {
                this.diffs.add(new Diff(Operation.TEST, currPath, source.get(srcIdx)));
            }
            this.diffs.add(Diff.generateDiff(Operation.REMOVE, currPath, source.get(srcIdx)));
            ++srcIdx;
        }
    }

    private int addRemaining(AbstractJsonPointer path, JsonNodeWrapper target, int pos, int targetIdx, int targetSize) {
        while (targetIdx < targetSize) {
            JsonNodeWrapper jsonNode = target.get(targetIdx);
            AbstractJsonPointer currPath = path.append(pos);
            this.diffs.add(Diff.generateDiff(Operation.ADD, currPath, jsonNode.deepCopy()));
            ++pos;
            ++targetIdx;
        }
        return pos;
    }

    private void compareObjects(AbstractJsonPointer path, JsonNodeWrapper source, JsonNodeWrapper target) {
        Iterator<String> keysFromSrc = source.fieldNames();
        while (keysFromSrc.hasNext()) {
            AbstractJsonPointer currPath;
            String key = keysFromSrc.next();
            if (!target.has(key)) {
                currPath = path.append(key);
                if (this.flags.contains((Object)DiffFlags.EMIT_TEST_OPERATIONS)) {
                    this.diffs.add(new Diff(Operation.TEST, currPath, source.get(key)));
                }
                this.diffs.add(Diff.generateDiff(Operation.REMOVE, currPath, source.get(key)));
                continue;
            }
            currPath = path.append(key);
            this.generateDiffs(currPath, source.get(key), target.get(key));
        }
        Iterator<String> keysFromTarget = target.fieldNames();
        while (keysFromTarget.hasNext()) {
            String key = keysFromTarget.next();
            if (source.has(key)) continue;
            AbstractJsonPointer currPath = path.append(key);
            this.diffs.add(Diff.generateDiff(Operation.ADD, currPath, target.get(key)));
        }
    }

    private static List<JsonNodeWrapper> getLCS(JsonNodeWrapper first, JsonNodeWrapper second) {
        return ListUtils.longestCommonSubsequence(InternalUtils.toList(first.arrayValue()), InternalUtils.toList(second.arrayValue()));
    }
}

