package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateParameterGroupRequest(
    parameterGroupName: String,
    parameterNameValues: Iterable[
      io.github.vigoo.zioaws.memorydb.model.ParameterNameValue
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.UpdateParameterGroupRequest = {
    import UpdateParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.UpdateParameterGroupRequest
      .builder()
      .parameterGroupName(parameterGroupName: java.lang.String)
      .parameterNameValues(parameterNameValues.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.UpdateParameterGroupRequest.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.UpdateParameterGroupRequest
      .wrap(buildAwsValue())
}
object UpdateParameterGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.UpdateParameterGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.memorydb.model.UpdateParameterGroupRequest =
      io.github.vigoo.zioaws.memorydb.model.UpdateParameterGroupRequest(
        parameterGroupNameValue,
        parameterNameValuesValue.map { item =>
          item.editable
        }
      )
    def parameterGroupNameValue: String
    def parameterNameValuesValue: List[
      io.github.vigoo.zioaws.memorydb.model.ParameterNameValue.ReadOnly
    ]
    def parameterGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(parameterGroupNameValue)
    def parameterNameValues: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.memorydb.model.ParameterNameValue.ReadOnly
    ]] = ZIO.succeed(parameterNameValuesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.UpdateParameterGroupRequest
  ) extends io.github.vigoo.zioaws.memorydb.model.UpdateParameterGroupRequest.ReadOnly {
    override def parameterGroupNameValue: String =
      impl.parameterGroupName(): String
    override def parameterNameValuesValue: List[
      io.github.vigoo.zioaws.memorydb.model.ParameterNameValue.ReadOnly
    ] = impl
      .parameterNameValues()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.memorydb.model.ParameterNameValue.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.UpdateParameterGroupRequest
  ): io.github.vigoo.zioaws.memorydb.model.UpdateParameterGroupRequest.ReadOnly =
    new Wrapper(impl)
}
