package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ServiceUpdateRequest(
    serviceUpdateNameToApply: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ServiceUpdateRequest = {
    import ServiceUpdateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ServiceUpdateRequest
      .builder()
      .optionallyWith(
        serviceUpdateNameToApply.map(value => value: java.lang.String)
      )(_.serviceUpdateNameToApply)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.ServiceUpdateRequest.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.ServiceUpdateRequest
      .wrap(buildAwsValue())
}
object ServiceUpdateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ServiceUpdateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.ServiceUpdateRequest =
      io.github.vigoo.zioaws.memorydb.model
        .ServiceUpdateRequest(serviceUpdateNameToApplyValue.map(value => value))
    def serviceUpdateNameToApplyValue: Option[String]
    def serviceUpdateNameToApply: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "serviceUpdateNameToApply",
        serviceUpdateNameToApplyValue
      )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ServiceUpdateRequest
  ) extends io.github.vigoo.zioaws.memorydb.model.ServiceUpdateRequest.ReadOnly {
    override def serviceUpdateNameToApplyValue: Option[String] =
      scala.Option(impl.serviceUpdateNameToApply()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ServiceUpdateRequest
  ): io.github.vigoo.zioaws.memorydb.model.ServiceUpdateRequest.ReadOnly =
    new Wrapper(impl)
}
