package io.github.vigoo.zioaws.memorydb.model
import io.github.vigoo.zioaws.memorydb.model.primitives.IntegerOptional
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeAcLsRequest(
    aclName: Option[String] = None,
    maxResults: Option[IntegerOptional] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeAcLsRequest = {
    import DescribeAcLsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeAcLsRequest
      .builder()
      .optionallyWith(aclName.map(value => value: java.lang.String))(_.aclName)
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.DescribeAcLsRequest.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.DescribeAcLsRequest
      .wrap(buildAwsValue())
}
object DescribeAcLsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeAcLsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.DescribeAcLsRequest =
      io.github.vigoo.zioaws.memorydb.model.DescribeAcLsRequest(
        aclNameValue.map(value => value),
        maxResultsValue.map(value => value),
        nextTokenValue.map(value => value)
      )
    def aclNameValue: Option[String]
    def maxResultsValue: Option[IntegerOptional]
    def nextTokenValue: Option[String]
    def aclName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("aclName", aclNameValue)
    def maxResults: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def nextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeAcLsRequest
  ) extends io.github.vigoo.zioaws.memorydb.model.DescribeAcLsRequest.ReadOnly {
    override def aclNameValue: Option[String] =
      scala.Option(impl.aclName()).map(value => value: String)
    override def maxResultsValue: Option[IntegerOptional] =
      scala.Option(impl.maxResults()).map(value => value: IntegerOptional)
    override def nextTokenValue: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeAcLsRequest
  ): io.github.vigoo.zioaws.memorydb.model.DescribeAcLsRequest.ReadOnly =
    new Wrapper(impl)
}
