package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteParameterGroupRequest(parameterGroupName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DeleteParameterGroupRequest = {
    import DeleteParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DeleteParameterGroupRequest
      .builder()
      .parameterGroupName(parameterGroupName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.DeleteParameterGroupRequest.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.DeleteParameterGroupRequest
      .wrap(buildAwsValue())
}
object DeleteParameterGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DeleteParameterGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.memorydb.model.DeleteParameterGroupRequest =
      io.github.vigoo.zioaws.memorydb.model
        .DeleteParameterGroupRequest(parameterGroupNameValue)
    def parameterGroupNameValue: String
    def parameterGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(parameterGroupNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DeleteParameterGroupRequest
  ) extends io.github.vigoo.zioaws.memorydb.model.DeleteParameterGroupRequest.ReadOnly {
    override def parameterGroupNameValue: String =
      impl.parameterGroupName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DeleteParameterGroupRequest
  ): io.github.vigoo.zioaws.memorydb.model.DeleteParameterGroupRequest.ReadOnly =
    new Wrapper(impl)
}
