package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BatchUpdateClusterResponse(
    processedClusters: Option[
      Iterable[io.github.vigoo.zioaws.memorydb.model.Cluster]
    ] = None,
    unprocessedClusters: Option[
      Iterable[io.github.vigoo.zioaws.memorydb.model.UnprocessedCluster]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.BatchUpdateClusterResponse = {
    import BatchUpdateClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.BatchUpdateClusterResponse
      .builder()
      .optionallyWith(
        processedClusters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processedClusters)
      .optionallyWith(
        unprocessedClusters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unprocessedClusters)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.BatchUpdateClusterResponse.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.BatchUpdateClusterResponse
      .wrap(buildAwsValue())
}
object BatchUpdateClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.BatchUpdateClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.memorydb.model.BatchUpdateClusterResponse =
      io.github.vigoo.zioaws.memorydb.model.BatchUpdateClusterResponse(
        processedClustersValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        unprocessedClustersValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def processedClustersValue
        : Option[List[io.github.vigoo.zioaws.memorydb.model.Cluster.ReadOnly]]
    def unprocessedClustersValue: Option[
      List[io.github.vigoo.zioaws.memorydb.model.UnprocessedCluster.ReadOnly]
    ]
    def processedClusters: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.memorydb.model.Cluster.ReadOnly
    ]] = AwsError.unwrapOptionField("processedClusters", processedClustersValue)
    def unprocessedClusters: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.memorydb.model.UnprocessedCluster.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "unprocessedClusters",
      unprocessedClustersValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.BatchUpdateClusterResponse
  ) extends io.github.vigoo.zioaws.memorydb.model.BatchUpdateClusterResponse.ReadOnly {
    override def processedClustersValue
        : Option[List[io.github.vigoo.zioaws.memorydb.model.Cluster.ReadOnly]] =
      scala
        .Option(impl.processedClusters())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.memorydb.model.Cluster.wrap(item)
          }.toList
        )
    override def unprocessedClustersValue: Option[
      List[io.github.vigoo.zioaws.memorydb.model.UnprocessedCluster.ReadOnly]
    ] = scala
      .Option(impl.unprocessedClusters())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.memorydb.model.UnprocessedCluster.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.BatchUpdateClusterResponse
  ): io.github.vigoo.zioaws.memorydb.model.BatchUpdateClusterResponse.ReadOnly =
    new Wrapper(impl)
}
