package io.github.vigoo.zioaws
import io.github.vigoo.zioaws.memorydb.model.CreateSnapshotResponse.ReadOnly
import io.github.vigoo.zioaws.core.{AwsServiceBase, AwsError}
import io.github.vigoo.zioaws.memorydb.MemoryDb
import io.github.vigoo.zioaws.memorydb.model.{
  DeleteUserRequest,
  DeleteSubnetGroupRequest,
  UpdateClusterRequest,
  DescribeUsersRequest,
  DescribeSubnetGroupsRequest,
  DescribeAcLsRequest,
  DescribeSnapshotsRequest,
  DeleteSnapshotRequest,
  ResetParameterGroupRequest,
  ListTagsRequest,
  DescribeEngineVersionsRequest,
  DescribeEventsRequest,
  DeleteAclRequest,
  CopySnapshotRequest,
  UpdateParameterGroupRequest,
  CreateParameterGroupRequest,
  CreateClusterRequest,
  UpdateSubnetGroupRequest,
  CreateUserRequest,
  DescribeServiceUpdatesRequest,
  DeleteClusterRequest,
  CreateSubnetGroupRequest,
  ListAllowedNodeTypeUpdatesRequest,
  CreateAclRequest,
  BatchUpdateClusterRequest,
  UpdateAclRequest,
  UntagResourceRequest,
  CreateSnapshotRequest,
  UpdateUserRequest,
  FailoverShardRequest,
  DeleteParameterGroupRequest,
  DescribeParametersRequest,
  DescribeParameterGroupsRequest,
  DescribeClustersRequest,
  TagResourceRequest
}
import io.github.vigoo.zioaws.core.config.AwsConfig
import zio.{ZManaged, IO, ZIO, ZLayer, URLayer, Has}
import software.amazon.awssdk.services.memorydb.model.{
  UpdateAclResponse,
  ParameterGroup,
  DescribeEventsResponse,
  DeleteParameterGroupResponse,
  Cluster,
  DescribeSnapshotsResponse,
  CreateAclResponse,
  DescribeSubnetGroupsResponse,
  DescribeParametersResponse,
  UpdateParameterGroupResponse,
  UpdateSubnetGroupResponse,
  CreateSubnetGroupResponse,
  EngineVersionInfo,
  User,
  BatchUpdateClusterResponse,
  SubnetGroup,
  Snapshot,
  UntagResourceResponse,
  CreateClusterResponse,
  CreateUserResponse,
  ACL,
  DescribeUsersResponse,
  DescribeServiceUpdatesResponse,
  FailoverShardResponse,
  CopySnapshotResponse,
  DescribeEngineVersionsResponse,
  DescribeClustersResponse,
  ListAllowedNodeTypeUpdatesResponse,
  DeleteAclResponse,
  ServiceUpdate,
  DeleteSubnetGroupResponse,
  DeleteUserResponse,
  Event,
  DeleteClusterResponse,
  DescribeAcLsResponse,
  UpdateUserResponse,
  TagResourceResponse,
  Parameter,
  CreateParameterGroupResponse,
  CreateSnapshotResponse,
  DescribeParameterGroupsResponse,
  DeleteSnapshotResponse,
  ResetParameterGroupResponse,
  ListTagsResponse,
  UpdateClusterResponse
}
import io.github.vigoo.zioaws.core.aspects.{AwsCallAspect, AspectSupport}
import software.amazon.awssdk.services.memorydb.{
  MemoryDbAsyncClientBuilder,
  MemoryDbAsyncClient
}
import zio.stream.ZStream
import zio.test.mock.{Proxy, Mock}
package object memorydb {
  import scala.jdk.CollectionConverters.*
  type MemoryDb = Has[MemoryDb.Service]
  object MemoryDb {
    trait Service extends AspectSupport[Service] {
      val api: MemoryDbAsyncClient
      def listAllowedNodeTypeUpdates(
          request: ListAllowedNodeTypeUpdatesRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.memorydb.model.ListAllowedNodeTypeUpdatesResponse.ReadOnly
      ]
      def deleteACL(request: DeleteAclRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.memorydb.model.DeleteAclResponse.ReadOnly
      ]
      def describeClusters(request: DescribeClustersRequest): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.memorydb.model.Cluster.ReadOnly
      ]
      def updateUser(request: UpdateUserRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.memorydb.model.UpdateUserResponse.ReadOnly
      ]
      def describeParameterGroups(
          request: DescribeParameterGroupsRequest
      ): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.memorydb.model.ParameterGroup.ReadOnly
      ]
      def batchUpdateCluster(request: BatchUpdateClusterRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.memorydb.model.BatchUpdateClusterResponse.ReadOnly
      ]
      def listTags(request: ListTagsRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.memorydb.model.ListTagsResponse.ReadOnly
      ]
      def describeParameters(request: DescribeParametersRequest): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.memorydb.model.Parameter.ReadOnly
      ]
      def copySnapshot(request: CopySnapshotRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.memorydb.model.CopySnapshotResponse.ReadOnly
      ]
      def createCluster(request: CreateClusterRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.memorydb.model.CreateClusterResponse.ReadOnly
      ]
      def deleteCluster(request: DeleteClusterRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.memorydb.model.DeleteClusterResponse.ReadOnly
      ]
      def createACL(request: CreateAclRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.memorydb.model.CreateAclResponse.ReadOnly
      ]
      def createUser(request: CreateUserRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.memorydb.model.CreateUserResponse.ReadOnly
      ]
      def updateCluster(request: UpdateClusterRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.memorydb.model.UpdateClusterResponse.ReadOnly
      ]
      def deleteSnapshot(request: DeleteSnapshotRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.memorydb.model.DeleteSnapshotResponse.ReadOnly
      ]
      def updateParameterGroup(request: UpdateParameterGroupRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.memorydb.model.UpdateParameterGroupResponse.ReadOnly
      ]
      def describeServiceUpdates(
          request: DescribeServiceUpdatesRequest
      ): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.memorydb.model.ServiceUpdate.ReadOnly
      ]
      def describeUsers(request: DescribeUsersRequest): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.memorydb.model.User.ReadOnly
      ]
      def untagResource(request: UntagResourceRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.memorydb.model.UntagResourceResponse.ReadOnly
      ]
      def failoverShard(request: FailoverShardRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.memorydb.model.FailoverShardResponse.ReadOnly
      ]
      def updateACL(request: UpdateAclRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.memorydb.model.UpdateAclResponse.ReadOnly
      ]
      def describeEngineVersions(
          request: DescribeEngineVersionsRequest
      ): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.memorydb.model.EngineVersionInfo.ReadOnly
      ]
      def deleteParameterGroup(request: DeleteParameterGroupRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.memorydb.model.DeleteParameterGroupResponse.ReadOnly
      ]
      def describeSnapshots(request: DescribeSnapshotsRequest): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.memorydb.model.Snapshot.ReadOnly
      ]
      def deleteSubnetGroup(request: DeleteSubnetGroupRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.memorydb.model.DeleteSubnetGroupResponse.ReadOnly
      ]
      def tagResource(request: TagResourceRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.memorydb.model.TagResourceResponse.ReadOnly
      ]
      def resetParameterGroup(request: ResetParameterGroupRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.memorydb.model.ResetParameterGroupResponse.ReadOnly
      ]
      def deleteUser(request: DeleteUserRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.memorydb.model.DeleteUserResponse.ReadOnly
      ]
      def createParameterGroup(request: CreateParameterGroupRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.memorydb.model.CreateParameterGroupResponse.ReadOnly
      ]
      def describeACLs(request: DescribeAcLsRequest): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.memorydb.model.ACL.ReadOnly
      ]
      def updateSubnetGroup(request: UpdateSubnetGroupRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.memorydb.model.UpdateSubnetGroupResponse.ReadOnly
      ]
      def createSnapshot(request: CreateSnapshotRequest): IO[AwsError, ReadOnly]
      def describeSubnetGroups(request: DescribeSubnetGroupsRequest): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.memorydb.model.SubnetGroup.ReadOnly
      ]
      def describeEvents(request: DescribeEventsRequest): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.memorydb.model.Event.ReadOnly
      ]
      def createSubnetGroup(request: CreateSubnetGroupRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.memorydb.model.CreateSubnetGroupResponse.ReadOnly
      ]
    }
    object MemoryDbMock extends Mock[MemoryDb] {
      object ListAllowedNodeTypeUpdates
          extends Effect[
            ListAllowedNodeTypeUpdatesRequest,
            AwsError,
            io.github.vigoo.zioaws.memorydb.model.ListAllowedNodeTypeUpdatesResponse.ReadOnly
          ]
      object DeleteACL
          extends Effect[
            DeleteAclRequest,
            AwsError,
            io.github.vigoo.zioaws.memorydb.model.DeleteAclResponse.ReadOnly
          ]
      object DescribeClusters
          extends Stream[
            DescribeClustersRequest,
            AwsError,
            io.github.vigoo.zioaws.memorydb.model.Cluster.ReadOnly
          ]
      object UpdateUser
          extends Effect[
            UpdateUserRequest,
            AwsError,
            io.github.vigoo.zioaws.memorydb.model.UpdateUserResponse.ReadOnly
          ]
      object DescribeParameterGroups
          extends Stream[
            DescribeParameterGroupsRequest,
            AwsError,
            io.github.vigoo.zioaws.memorydb.model.ParameterGroup.ReadOnly
          ]
      object BatchUpdateCluster
          extends Effect[
            BatchUpdateClusterRequest,
            AwsError,
            io.github.vigoo.zioaws.memorydb.model.BatchUpdateClusterResponse.ReadOnly
          ]
      object ListTags
          extends Effect[
            ListTagsRequest,
            AwsError,
            io.github.vigoo.zioaws.memorydb.model.ListTagsResponse.ReadOnly
          ]
      object DescribeParameters
          extends Stream[
            DescribeParametersRequest,
            AwsError,
            io.github.vigoo.zioaws.memorydb.model.Parameter.ReadOnly
          ]
      object CopySnapshot
          extends Effect[
            CopySnapshotRequest,
            AwsError,
            io.github.vigoo.zioaws.memorydb.model.CopySnapshotResponse.ReadOnly
          ]
      object CreateCluster
          extends Effect[
            CreateClusterRequest,
            AwsError,
            io.github.vigoo.zioaws.memorydb.model.CreateClusterResponse.ReadOnly
          ]
      object DeleteCluster
          extends Effect[
            DeleteClusterRequest,
            AwsError,
            io.github.vigoo.zioaws.memorydb.model.DeleteClusterResponse.ReadOnly
          ]
      object CreateACL
          extends Effect[
            CreateAclRequest,
            AwsError,
            io.github.vigoo.zioaws.memorydb.model.CreateAclResponse.ReadOnly
          ]
      object CreateUser
          extends Effect[
            CreateUserRequest,
            AwsError,
            io.github.vigoo.zioaws.memorydb.model.CreateUserResponse.ReadOnly
          ]
      object UpdateCluster
          extends Effect[
            UpdateClusterRequest,
            AwsError,
            io.github.vigoo.zioaws.memorydb.model.UpdateClusterResponse.ReadOnly
          ]
      object DeleteSnapshot
          extends Effect[
            DeleteSnapshotRequest,
            AwsError,
            io.github.vigoo.zioaws.memorydb.model.DeleteSnapshotResponse.ReadOnly
          ]
      object UpdateParameterGroup
          extends Effect[
            UpdateParameterGroupRequest,
            AwsError,
            io.github.vigoo.zioaws.memorydb.model.UpdateParameterGroupResponse.ReadOnly
          ]
      object DescribeServiceUpdates
          extends Stream[
            DescribeServiceUpdatesRequest,
            AwsError,
            io.github.vigoo.zioaws.memorydb.model.ServiceUpdate.ReadOnly
          ]
      object DescribeUsers
          extends Stream[
            DescribeUsersRequest,
            AwsError,
            io.github.vigoo.zioaws.memorydb.model.User.ReadOnly
          ]
      object UntagResource
          extends Effect[
            UntagResourceRequest,
            AwsError,
            io.github.vigoo.zioaws.memorydb.model.UntagResourceResponse.ReadOnly
          ]
      object FailoverShard
          extends Effect[
            FailoverShardRequest,
            AwsError,
            io.github.vigoo.zioaws.memorydb.model.FailoverShardResponse.ReadOnly
          ]
      object UpdateACL
          extends Effect[
            UpdateAclRequest,
            AwsError,
            io.github.vigoo.zioaws.memorydb.model.UpdateAclResponse.ReadOnly
          ]
      object DescribeEngineVersions
          extends Stream[
            DescribeEngineVersionsRequest,
            AwsError,
            io.github.vigoo.zioaws.memorydb.model.EngineVersionInfo.ReadOnly
          ]
      object DeleteParameterGroup
          extends Effect[
            DeleteParameterGroupRequest,
            AwsError,
            io.github.vigoo.zioaws.memorydb.model.DeleteParameterGroupResponse.ReadOnly
          ]
      object DescribeSnapshots
          extends Stream[
            DescribeSnapshotsRequest,
            AwsError,
            io.github.vigoo.zioaws.memorydb.model.Snapshot.ReadOnly
          ]
      object DeleteSubnetGroup
          extends Effect[
            DeleteSubnetGroupRequest,
            AwsError,
            io.github.vigoo.zioaws.memorydb.model.DeleteSubnetGroupResponse.ReadOnly
          ]
      object TagResource
          extends Effect[
            TagResourceRequest,
            AwsError,
            io.github.vigoo.zioaws.memorydb.model.TagResourceResponse.ReadOnly
          ]
      object ResetParameterGroup
          extends Effect[
            ResetParameterGroupRequest,
            AwsError,
            io.github.vigoo.zioaws.memorydb.model.ResetParameterGroupResponse.ReadOnly
          ]
      object DeleteUser
          extends Effect[
            DeleteUserRequest,
            AwsError,
            io.github.vigoo.zioaws.memorydb.model.DeleteUserResponse.ReadOnly
          ]
      object CreateParameterGroup
          extends Effect[
            CreateParameterGroupRequest,
            AwsError,
            io.github.vigoo.zioaws.memorydb.model.CreateParameterGroupResponse.ReadOnly
          ]
      object DescribeACLs
          extends Stream[
            DescribeAcLsRequest,
            AwsError,
            io.github.vigoo.zioaws.memorydb.model.ACL.ReadOnly
          ]
      object UpdateSubnetGroup
          extends Effect[
            UpdateSubnetGroupRequest,
            AwsError,
            io.github.vigoo.zioaws.memorydb.model.UpdateSubnetGroupResponse.ReadOnly
          ]
      object CreateSnapshot
          extends Effect[CreateSnapshotRequest, AwsError, ReadOnly]
      object DescribeSubnetGroups
          extends Stream[
            DescribeSubnetGroupsRequest,
            AwsError,
            io.github.vigoo.zioaws.memorydb.model.SubnetGroup.ReadOnly
          ]
      object DescribeEvents
          extends Stream[
            DescribeEventsRequest,
            AwsError,
            io.github.vigoo.zioaws.memorydb.model.Event.ReadOnly
          ]
      object CreateSubnetGroup
          extends Effect[
            CreateSubnetGroupRequest,
            AwsError,
            io.github.vigoo.zioaws.memorydb.model.CreateSubnetGroupResponse.ReadOnly
          ]
      val compose: URLayer[Has[Proxy], MemoryDb] = ZLayer.fromServiceM {
        proxy =>
          withRuntime.map { rts =>
            new MemoryDb.Service {
              val api: MemoryDbAsyncClient = null
              def withAspect[R1](
                  newAspect: AwsCallAspect[R1],
                  r: R1
              ): MemoryDb.Service = this
              def listAllowedNodeTypeUpdates(
                  request: ListAllowedNodeTypeUpdatesRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.memorydb.model.ListAllowedNodeTypeUpdatesResponse.ReadOnly
              ] = proxy(ListAllowedNodeTypeUpdates, request)
              def deleteACL(request: DeleteAclRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.memorydb.model.DeleteAclResponse.ReadOnly
              ] = proxy(DeleteACL, request)
              def describeClusters(request: DescribeClustersRequest): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.memorydb.model.Cluster.ReadOnly
              ] = rts.unsafeRun(proxy(DescribeClusters, request))
              def updateUser(request: UpdateUserRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.memorydb.model.UpdateUserResponse.ReadOnly
              ] = proxy(UpdateUser, request)
              def describeParameterGroups(
                  request: DescribeParameterGroupsRequest
              ): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.memorydb.model.ParameterGroup.ReadOnly
              ] = rts.unsafeRun(proxy(DescribeParameterGroups, request))
              def batchUpdateCluster(request: BatchUpdateClusterRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.memorydb.model.BatchUpdateClusterResponse.ReadOnly
              ] = proxy(BatchUpdateCluster, request)
              def listTags(request: ListTagsRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.memorydb.model.ListTagsResponse.ReadOnly
              ] = proxy(ListTags, request)
              def describeParameters(
                  request: DescribeParametersRequest
              ): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.memorydb.model.Parameter.ReadOnly
              ] = rts.unsafeRun(proxy(DescribeParameters, request))
              def copySnapshot(request: CopySnapshotRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.memorydb.model.CopySnapshotResponse.ReadOnly
              ] = proxy(CopySnapshot, request)
              def createCluster(request: CreateClusterRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.memorydb.model.CreateClusterResponse.ReadOnly
              ] = proxy(CreateCluster, request)
              def deleteCluster(request: DeleteClusterRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.memorydb.model.DeleteClusterResponse.ReadOnly
              ] = proxy(DeleteCluster, request)
              def createACL(request: CreateAclRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.memorydb.model.CreateAclResponse.ReadOnly
              ] = proxy(CreateACL, request)
              def createUser(request: CreateUserRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.memorydb.model.CreateUserResponse.ReadOnly
              ] = proxy(CreateUser, request)
              def updateCluster(request: UpdateClusterRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.memorydb.model.UpdateClusterResponse.ReadOnly
              ] = proxy(UpdateCluster, request)
              def deleteSnapshot(request: DeleteSnapshotRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.memorydb.model.DeleteSnapshotResponse.ReadOnly
              ] = proxy(DeleteSnapshot, request)
              def updateParameterGroup(
                  request: UpdateParameterGroupRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.memorydb.model.UpdateParameterGroupResponse.ReadOnly
              ] = proxy(UpdateParameterGroup, request)
              def describeServiceUpdates(
                  request: DescribeServiceUpdatesRequest
              ): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.memorydb.model.ServiceUpdate.ReadOnly
              ] = rts.unsafeRun(proxy(DescribeServiceUpdates, request))
              def describeUsers(request: DescribeUsersRequest): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.memorydb.model.User.ReadOnly
              ] = rts.unsafeRun(proxy(DescribeUsers, request))
              def untagResource(request: UntagResourceRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.memorydb.model.UntagResourceResponse.ReadOnly
              ] = proxy(UntagResource, request)
              def failoverShard(request: FailoverShardRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.memorydb.model.FailoverShardResponse.ReadOnly
              ] = proxy(FailoverShard, request)
              def updateACL(request: UpdateAclRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.memorydb.model.UpdateAclResponse.ReadOnly
              ] = proxy(UpdateACL, request)
              def describeEngineVersions(
                  request: DescribeEngineVersionsRequest
              ): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.memorydb.model.EngineVersionInfo.ReadOnly
              ] = rts.unsafeRun(proxy(DescribeEngineVersions, request))
              def deleteParameterGroup(
                  request: DeleteParameterGroupRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.memorydb.model.DeleteParameterGroupResponse.ReadOnly
              ] = proxy(DeleteParameterGroup, request)
              def describeSnapshots(request: DescribeSnapshotsRequest): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.memorydb.model.Snapshot.ReadOnly
              ] = rts.unsafeRun(proxy(DescribeSnapshots, request))
              def deleteSubnetGroup(request: DeleteSubnetGroupRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.memorydb.model.DeleteSubnetGroupResponse.ReadOnly
              ] = proxy(DeleteSubnetGroup, request)
              def tagResource(request: TagResourceRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.memorydb.model.TagResourceResponse.ReadOnly
              ] = proxy(TagResource, request)
              def resetParameterGroup(request: ResetParameterGroupRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.memorydb.model.ResetParameterGroupResponse.ReadOnly
              ] = proxy(ResetParameterGroup, request)
              def deleteUser(request: DeleteUserRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.memorydb.model.DeleteUserResponse.ReadOnly
              ] = proxy(DeleteUser, request)
              def createParameterGroup(
                  request: CreateParameterGroupRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.memorydb.model.CreateParameterGroupResponse.ReadOnly
              ] = proxy(CreateParameterGroup, request)
              def describeACLs(request: DescribeAcLsRequest): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.memorydb.model.ACL.ReadOnly
              ] = rts.unsafeRun(proxy(DescribeACLs, request))
              def updateSubnetGroup(request: UpdateSubnetGroupRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.memorydb.model.UpdateSubnetGroupResponse.ReadOnly
              ] = proxy(UpdateSubnetGroup, request)
              def createSnapshot(
                  request: CreateSnapshotRequest
              ): IO[AwsError, ReadOnly] = proxy(CreateSnapshot, request)
              def describeSubnetGroups(
                  request: DescribeSubnetGroupsRequest
              ): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.memorydb.model.SubnetGroup.ReadOnly
              ] = rts.unsafeRun(proxy(DescribeSubnetGroups, request))
              def describeEvents(request: DescribeEventsRequest): ZStream[
                Any,
                AwsError,
                io.github.vigoo.zioaws.memorydb.model.Event.ReadOnly
              ] = rts.unsafeRun(proxy(DescribeEvents, request))
              def createSubnetGroup(request: CreateSubnetGroupRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.memorydb.model.CreateSubnetGroupResponse.ReadOnly
              ] = proxy(CreateSubnetGroup, request)
            }
          }
      }
    }
  }
  val live: ZLayer[AwsConfig, java.lang.Throwable, MemoryDb] = customized(
    identity
  )
  def customized(
      customization: MemoryDbAsyncClientBuilder => MemoryDbAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, MemoryDb] = managed(
    customization
  ).toLayer
  def managed(
      customization: MemoryDbAsyncClientBuilder => MemoryDbAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, MemoryDb.Service] = for (
    awsConfig <- ZManaged.service[AwsConfig.Service];
    executor <- ZIO.executor.toManaged_;
    builder = MemoryDbAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[MemoryDbAsyncClient, MemoryDbAsyncClientBuilder](builder)
      .toManaged_;
    b1 <- awsConfig
      .configureHttpClient[MemoryDbAsyncClient, MemoryDbAsyncClientBuilder](
        b0,
        io.github.vigoo.zioaws.core.httpclient
          .ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged_; client <- zio.ZIO(customization(b1).build()).toManaged_
  ) yield new MemoryDbImpl(client, AwsCallAspect.identity, ().asInstanceOf[Any])
  private class MemoryDbImpl[R](
      override val api: MemoryDbAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: R
  ) extends MemoryDb.Service
      with AwsServiceBase[R, MemoryDbImpl] {
    override val serviceName: String = "MemoryDb"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: R1
    ): MemoryDbImpl[R1] = new MemoryDbImpl(api, newAspect, r)
    def listAllowedNodeTypeUpdates(
        request: ListAllowedNodeTypeUpdatesRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.ListAllowedNodeTypeUpdatesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.memorydb.model.ListAllowedNodeTypeUpdatesRequest,
      ListAllowedNodeTypeUpdatesResponse
    ]("listAllowedNodeTypeUpdates", api.listAllowedNodeTypeUpdates)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.memorydb.model.ListAllowedNodeTypeUpdatesResponse.wrap
    ).provide(r)
    def deleteACL(request: DeleteAclRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.DeleteAclResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.memorydb.model.DeleteAclRequest,
      DeleteAclResponse
    ]("deleteACL", api.deleteACL)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.memorydb.model.DeleteAclResponse.wrap)
      .provide(r)
    def describeClusters(request: DescribeClustersRequest): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.Cluster.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.memorydb.model.DescribeClustersRequest,
      DescribeClustersResponse,
      Cluster
    ](
      "describeClusters",
      api.describeClusters,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.clusters().asScala)
    )(request.buildAwsValue())
      .map(item => io.github.vigoo.zioaws.memorydb.model.Cluster.wrap(item))
      .provide(r)
    def updateUser(request: UpdateUserRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.UpdateUserResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.memorydb.model.UpdateUserRequest,
      UpdateUserResponse
    ]("updateUser", api.updateUser)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.memorydb.model.UpdateUserResponse.wrap)
      .provide(r)
    def describeParameterGroups(
        request: DescribeParameterGroupsRequest
    ): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.ParameterGroup.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsRequest,
      DescribeParameterGroupsResponse,
      ParameterGroup
    ](
      "describeParameterGroups",
      api.describeParameterGroups,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.parameterGroups().asScala)
    )(request.buildAwsValue())
      .map(item =>
        io.github.vigoo.zioaws.memorydb.model.ParameterGroup.wrap(item)
      )
      .provide(r)
    def batchUpdateCluster(request: BatchUpdateClusterRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.BatchUpdateClusterResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.memorydb.model.BatchUpdateClusterRequest,
      BatchUpdateClusterResponse
    ]("batchUpdateCluster", api.batchUpdateCluster)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.memorydb.model.BatchUpdateClusterResponse.wrap
      )
      .provide(r)
    def listTags(request: ListTagsRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.ListTagsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.memorydb.model.ListTagsRequest,
      ListTagsResponse
    ]("listTags", api.listTags)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.memorydb.model.ListTagsResponse.wrap)
      .provide(r)
    def describeParameters(request: DescribeParametersRequest): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.Parameter.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.memorydb.model.DescribeParametersRequest,
      DescribeParametersResponse,
      Parameter
    ](
      "describeParameters",
      api.describeParameters,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.parameters().asScala)
    )(request.buildAwsValue())
      .map(item => io.github.vigoo.zioaws.memorydb.model.Parameter.wrap(item))
      .provide(r)
    def copySnapshot(request: CopySnapshotRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.CopySnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.memorydb.model.CopySnapshotRequest,
      CopySnapshotResponse
    ]("copySnapshot", api.copySnapshot)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.memorydb.model.CopySnapshotResponse.wrap)
      .provide(r)
    def createCluster(request: CreateClusterRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.CreateClusterResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.memorydb.model.CreateClusterRequest,
      CreateClusterResponse
    ]("createCluster", api.createCluster)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.memorydb.model.CreateClusterResponse.wrap)
      .provide(r)
    def deleteCluster(request: DeleteClusterRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.DeleteClusterResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.memorydb.model.DeleteClusterRequest,
      DeleteClusterResponse
    ]("deleteCluster", api.deleteCluster)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.memorydb.model.DeleteClusterResponse.wrap)
      .provide(r)
    def createACL(request: CreateAclRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.CreateAclResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.memorydb.model.CreateAclRequest,
      CreateAclResponse
    ]("createACL", api.createACL)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.memorydb.model.CreateAclResponse.wrap)
      .provide(r)
    def createUser(request: CreateUserRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.CreateUserResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.memorydb.model.CreateUserRequest,
      CreateUserResponse
    ]("createUser", api.createUser)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.memorydb.model.CreateUserResponse.wrap)
      .provide(r)
    def updateCluster(request: UpdateClusterRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.UpdateClusterResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.memorydb.model.UpdateClusterRequest,
      UpdateClusterResponse
    ]("updateCluster", api.updateCluster)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.memorydb.model.UpdateClusterResponse.wrap)
      .provide(r)
    def deleteSnapshot(request: DeleteSnapshotRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.DeleteSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.memorydb.model.DeleteSnapshotRequest,
      DeleteSnapshotResponse
    ]("deleteSnapshot", api.deleteSnapshot)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.memorydb.model.DeleteSnapshotResponse.wrap)
      .provide(r)
    def updateParameterGroup(request: UpdateParameterGroupRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.UpdateParameterGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.memorydb.model.UpdateParameterGroupRequest,
      UpdateParameterGroupResponse
    ]("updateParameterGroup", api.updateParameterGroup)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.memorydb.model.UpdateParameterGroupResponse.wrap
      )
      .provide(r)
    def describeServiceUpdates(request: DescribeServiceUpdatesRequest): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.ServiceUpdate.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesRequest,
      DescribeServiceUpdatesResponse,
      ServiceUpdate
    ](
      "describeServiceUpdates",
      api.describeServiceUpdates,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.serviceUpdates().asScala)
    )(request.buildAwsValue())
      .map(item =>
        io.github.vigoo.zioaws.memorydb.model.ServiceUpdate.wrap(item)
      )
      .provide(r)
    def describeUsers(request: DescribeUsersRequest): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.User.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.memorydb.model.DescribeUsersRequest,
      DescribeUsersResponse,
      User
    ](
      "describeUsers",
      api.describeUsers,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.users().asScala)
    )(request.buildAwsValue())
      .map(item => io.github.vigoo.zioaws.memorydb.model.User.wrap(item))
      .provide(r)
    def untagResource(request: UntagResourceRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.memorydb.model.UntagResourceRequest,
      UntagResourceResponse
    ]("untagResource", api.untagResource)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.memorydb.model.UntagResourceResponse.wrap)
      .provide(r)
    def failoverShard(request: FailoverShardRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.FailoverShardResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.memorydb.model.FailoverShardRequest,
      FailoverShardResponse
    ]("failoverShard", api.failoverShard)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.memorydb.model.FailoverShardResponse.wrap)
      .provide(r)
    def updateACL(request: UpdateAclRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.UpdateAclResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.memorydb.model.UpdateAclRequest,
      UpdateAclResponse
    ]("updateACL", api.updateACL)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.memorydb.model.UpdateAclResponse.wrap)
      .provide(r)
    def describeEngineVersions(request: DescribeEngineVersionsRequest): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.EngineVersionInfo.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsRequest,
      DescribeEngineVersionsResponse,
      EngineVersionInfo
    ](
      "describeEngineVersions",
      api.describeEngineVersions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.engineVersions().asScala)
    )(request.buildAwsValue())
      .map(item =>
        io.github.vigoo.zioaws.memorydb.model.EngineVersionInfo.wrap(item)
      )
      .provide(r)
    def deleteParameterGroup(request: DeleteParameterGroupRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.DeleteParameterGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.memorydb.model.DeleteParameterGroupRequest,
      DeleteParameterGroupResponse
    ]("deleteParameterGroup", api.deleteParameterGroup)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.memorydb.model.DeleteParameterGroupResponse.wrap
      )
      .provide(r)
    def describeSnapshots(request: DescribeSnapshotsRequest): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.Snapshot.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsRequest,
      DescribeSnapshotsResponse,
      Snapshot
    ](
      "describeSnapshots",
      api.describeSnapshots,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.snapshots().asScala)
    )(request.buildAwsValue())
      .map(item => io.github.vigoo.zioaws.memorydb.model.Snapshot.wrap(item))
      .provide(r)
    def deleteSubnetGroup(request: DeleteSubnetGroupRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.DeleteSubnetGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.memorydb.model.DeleteSubnetGroupRequest,
      DeleteSubnetGroupResponse
    ]("deleteSubnetGroup", api.deleteSubnetGroup)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.memorydb.model.DeleteSubnetGroupResponse.wrap)
      .provide(r)
    def tagResource(request: TagResourceRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.TagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.memorydb.model.TagResourceRequest,
      TagResourceResponse
    ]("tagResource", api.tagResource)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.memorydb.model.TagResourceResponse.wrap)
      .provide(r)
    def resetParameterGroup(request: ResetParameterGroupRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.ResetParameterGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.memorydb.model.ResetParameterGroupRequest,
      ResetParameterGroupResponse
    ]("resetParameterGroup", api.resetParameterGroup)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.memorydb.model.ResetParameterGroupResponse.wrap
      )
      .provide(r)
    def deleteUser(request: DeleteUserRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.DeleteUserResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.memorydb.model.DeleteUserRequest,
      DeleteUserResponse
    ]("deleteUser", api.deleteUser)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.memorydb.model.DeleteUserResponse.wrap)
      .provide(r)
    def createParameterGroup(request: CreateParameterGroupRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.CreateParameterGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.memorydb.model.CreateParameterGroupRequest,
      CreateParameterGroupResponse
    ]("createParameterGroup", api.createParameterGroup)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.memorydb.model.CreateParameterGroupResponse.wrap
      )
      .provide(r)
    def describeACLs(request: DescribeAcLsRequest): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.ACL.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.memorydb.model.DescribeAcLsRequest,
      DescribeAcLsResponse,
      ACL
    ](
      "describeACLs",
      api.describeACLs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.acLs().asScala)
    )(request.buildAwsValue())
      .map(item => io.github.vigoo.zioaws.memorydb.model.ACL.wrap(item))
      .provide(r)
    def updateSubnetGroup(request: UpdateSubnetGroupRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.UpdateSubnetGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.memorydb.model.UpdateSubnetGroupRequest,
      UpdateSubnetGroupResponse
    ]("updateSubnetGroup", api.updateSubnetGroup)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.memorydb.model.UpdateSubnetGroupResponse.wrap)
      .provide(r)
    def createSnapshot(request: CreateSnapshotRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.memorydb.model.CreateSnapshotRequest,
        CreateSnapshotResponse
      ]("createSnapshot", api.createSnapshot)(request.buildAwsValue())
        .map(io.github.vigoo.zioaws.memorydb.model.CreateSnapshotResponse.wrap)
        .provide(r)
    def describeSubnetGroups(request: DescribeSubnetGroupsRequest): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.SubnetGroup.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsRequest,
      DescribeSubnetGroupsResponse,
      SubnetGroup
    ](
      "describeSubnetGroups",
      api.describeSubnetGroups,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.subnetGroups().asScala)
    )(request.buildAwsValue())
      .map(item => io.github.vigoo.zioaws.memorydb.model.SubnetGroup.wrap(item))
      .provide(r)
    def describeEvents(request: DescribeEventsRequest): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.Event.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.memorydb.model.DescribeEventsRequest,
      DescribeEventsResponse,
      Event
    ](
      "describeEvents",
      api.describeEvents,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.events().asScala)
    )(request.buildAwsValue())
      .map(item => io.github.vigoo.zioaws.memorydb.model.Event.wrap(item))
      .provide(r)
    def createSubnetGroup(request: CreateSubnetGroupRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.CreateSubnetGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.memorydb.model.CreateSubnetGroupRequest,
      CreateSubnetGroupResponse
    ]("createSubnetGroup", api.createSubnetGroup)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.memorydb.model.CreateSubnetGroupResponse.wrap)
      .provide(r)
  }
  def listAllowedNodeTypeUpdates(
      request: ListAllowedNodeTypeUpdatesRequest
  ): ZIO[
    MemoryDb,
    AwsError,
    io.github.vigoo.zioaws.memorydb.model.ListAllowedNodeTypeUpdatesResponse.ReadOnly
  ] = ZIO.accessM(_.get.listAllowedNodeTypeUpdates(request))
  def deleteACL(request: DeleteAclRequest): ZIO[
    MemoryDb,
    AwsError,
    io.github.vigoo.zioaws.memorydb.model.DeleteAclResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteACL(request))
  def describeClusters(request: DescribeClustersRequest): ZStream[
    MemoryDb,
    AwsError,
    io.github.vigoo.zioaws.memorydb.model.Cluster.ReadOnly
  ] = ZStream.accessStream(_.get.describeClusters(request))
  def updateUser(request: UpdateUserRequest): ZIO[
    MemoryDb,
    AwsError,
    io.github.vigoo.zioaws.memorydb.model.UpdateUserResponse.ReadOnly
  ] = ZIO.accessM(_.get.updateUser(request))
  def describeParameterGroups(request: DescribeParameterGroupsRequest): ZStream[
    MemoryDb,
    AwsError,
    io.github.vigoo.zioaws.memorydb.model.ParameterGroup.ReadOnly
  ] = ZStream.accessStream(_.get.describeParameterGroups(request))
  def batchUpdateCluster(request: BatchUpdateClusterRequest): ZIO[
    MemoryDb,
    AwsError,
    io.github.vigoo.zioaws.memorydb.model.BatchUpdateClusterResponse.ReadOnly
  ] = ZIO.accessM(_.get.batchUpdateCluster(request))
  def listTags(request: ListTagsRequest): ZIO[
    MemoryDb,
    AwsError,
    io.github.vigoo.zioaws.memorydb.model.ListTagsResponse.ReadOnly
  ] = ZIO.accessM(_.get.listTags(request))
  def describeParameters(request: DescribeParametersRequest): ZStream[
    MemoryDb,
    AwsError,
    io.github.vigoo.zioaws.memorydb.model.Parameter.ReadOnly
  ] = ZStream.accessStream(_.get.describeParameters(request))
  def copySnapshot(request: CopySnapshotRequest): ZIO[
    MemoryDb,
    AwsError,
    io.github.vigoo.zioaws.memorydb.model.CopySnapshotResponse.ReadOnly
  ] = ZIO.accessM(_.get.copySnapshot(request))
  def createCluster(request: CreateClusterRequest): ZIO[
    MemoryDb,
    AwsError,
    io.github.vigoo.zioaws.memorydb.model.CreateClusterResponse.ReadOnly
  ] = ZIO.accessM(_.get.createCluster(request))
  def deleteCluster(request: DeleteClusterRequest): ZIO[
    MemoryDb,
    AwsError,
    io.github.vigoo.zioaws.memorydb.model.DeleteClusterResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteCluster(request))
  def createACL(request: CreateAclRequest): ZIO[
    MemoryDb,
    AwsError,
    io.github.vigoo.zioaws.memorydb.model.CreateAclResponse.ReadOnly
  ] = ZIO.accessM(_.get.createACL(request))
  def createUser(request: CreateUserRequest): ZIO[
    MemoryDb,
    AwsError,
    io.github.vigoo.zioaws.memorydb.model.CreateUserResponse.ReadOnly
  ] = ZIO.accessM(_.get.createUser(request))
  def updateCluster(request: UpdateClusterRequest): ZIO[
    MemoryDb,
    AwsError,
    io.github.vigoo.zioaws.memorydb.model.UpdateClusterResponse.ReadOnly
  ] = ZIO.accessM(_.get.updateCluster(request))
  def deleteSnapshot(request: DeleteSnapshotRequest): ZIO[
    MemoryDb,
    AwsError,
    io.github.vigoo.zioaws.memorydb.model.DeleteSnapshotResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteSnapshot(request))
  def updateParameterGroup(request: UpdateParameterGroupRequest): ZIO[
    MemoryDb,
    AwsError,
    io.github.vigoo.zioaws.memorydb.model.UpdateParameterGroupResponse.ReadOnly
  ] = ZIO.accessM(_.get.updateParameterGroup(request))
  def describeServiceUpdates(request: DescribeServiceUpdatesRequest): ZStream[
    MemoryDb,
    AwsError,
    io.github.vigoo.zioaws.memorydb.model.ServiceUpdate.ReadOnly
  ] = ZStream.accessStream(_.get.describeServiceUpdates(request))
  def describeUsers(request: DescribeUsersRequest): ZStream[
    MemoryDb,
    AwsError,
    io.github.vigoo.zioaws.memorydb.model.User.ReadOnly
  ] = ZStream.accessStream(_.get.describeUsers(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    MemoryDb,
    AwsError,
    io.github.vigoo.zioaws.memorydb.model.UntagResourceResponse.ReadOnly
  ] = ZIO.accessM(_.get.untagResource(request))
  def failoverShard(request: FailoverShardRequest): ZIO[
    MemoryDb,
    AwsError,
    io.github.vigoo.zioaws.memorydb.model.FailoverShardResponse.ReadOnly
  ] = ZIO.accessM(_.get.failoverShard(request))
  def updateACL(request: UpdateAclRequest): ZIO[
    MemoryDb,
    AwsError,
    io.github.vigoo.zioaws.memorydb.model.UpdateAclResponse.ReadOnly
  ] = ZIO.accessM(_.get.updateACL(request))
  def describeEngineVersions(request: DescribeEngineVersionsRequest): ZStream[
    MemoryDb,
    AwsError,
    io.github.vigoo.zioaws.memorydb.model.EngineVersionInfo.ReadOnly
  ] = ZStream.accessStream(_.get.describeEngineVersions(request))
  def deleteParameterGroup(request: DeleteParameterGroupRequest): ZIO[
    MemoryDb,
    AwsError,
    io.github.vigoo.zioaws.memorydb.model.DeleteParameterGroupResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteParameterGroup(request))
  def describeSnapshots(request: DescribeSnapshotsRequest): ZStream[
    MemoryDb,
    AwsError,
    io.github.vigoo.zioaws.memorydb.model.Snapshot.ReadOnly
  ] = ZStream.accessStream(_.get.describeSnapshots(request))
  def deleteSubnetGroup(request: DeleteSubnetGroupRequest): ZIO[
    MemoryDb,
    AwsError,
    io.github.vigoo.zioaws.memorydb.model.DeleteSubnetGroupResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteSubnetGroup(request))
  def tagResource(request: TagResourceRequest): ZIO[
    MemoryDb,
    AwsError,
    io.github.vigoo.zioaws.memorydb.model.TagResourceResponse.ReadOnly
  ] = ZIO.accessM(_.get.tagResource(request))
  def resetParameterGroup(request: ResetParameterGroupRequest): ZIO[
    MemoryDb,
    AwsError,
    io.github.vigoo.zioaws.memorydb.model.ResetParameterGroupResponse.ReadOnly
  ] = ZIO.accessM(_.get.resetParameterGroup(request))
  def deleteUser(request: DeleteUserRequest): ZIO[
    MemoryDb,
    AwsError,
    io.github.vigoo.zioaws.memorydb.model.DeleteUserResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteUser(request))
  def createParameterGroup(request: CreateParameterGroupRequest): ZIO[
    MemoryDb,
    AwsError,
    io.github.vigoo.zioaws.memorydb.model.CreateParameterGroupResponse.ReadOnly
  ] = ZIO.accessM(_.get.createParameterGroup(request))
  def describeACLs(request: DescribeAcLsRequest): ZStream[
    MemoryDb,
    AwsError,
    io.github.vigoo.zioaws.memorydb.model.ACL.ReadOnly
  ] = ZStream.accessStream(_.get.describeACLs(request))
  def updateSubnetGroup(request: UpdateSubnetGroupRequest): ZIO[
    MemoryDb,
    AwsError,
    io.github.vigoo.zioaws.memorydb.model.UpdateSubnetGroupResponse.ReadOnly
  ] = ZIO.accessM(_.get.updateSubnetGroup(request))
  def createSnapshot(
      request: CreateSnapshotRequest
  ): ZIO[MemoryDb, AwsError, ReadOnly] =
    ZIO.accessM(_.get.createSnapshot(request))
  def describeSubnetGroups(request: DescribeSubnetGroupsRequest): ZStream[
    MemoryDb,
    AwsError,
    io.github.vigoo.zioaws.memorydb.model.SubnetGroup.ReadOnly
  ] = ZStream.accessStream(_.get.describeSubnetGroups(request))
  def describeEvents(request: DescribeEventsRequest): ZStream[
    MemoryDb,
    AwsError,
    io.github.vigoo.zioaws.memorydb.model.Event.ReadOnly
  ] = ZStream.accessStream(_.get.describeEvents(request))
  def createSubnetGroup(request: CreateSubnetGroupRequest): ZIO[
    MemoryDb,
    AwsError,
    io.github.vigoo.zioaws.memorydb.model.CreateSubnetGroupResponse.ReadOnly
  ] = ZIO.accessM(_.get.createSubnetGroup(request))
}
