package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ResetParameterGroupResponse(
    parameterGroup: Option[
      io.github.vigoo.zioaws.memorydb.model.ParameterGroup
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ResetParameterGroupResponse = {
    import ResetParameterGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ResetParameterGroupResponse
      .builder()
      .optionallyWith(parameterGroup.map(value => value.buildAwsValue()))(
        _.parameterGroup
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.ResetParameterGroupResponse.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.ResetParameterGroupResponse
      .wrap(buildAwsValue())
}
object ResetParameterGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ResetParameterGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.memorydb.model.ResetParameterGroupResponse =
      io.github.vigoo.zioaws.memorydb.model.ResetParameterGroupResponse(
        parameterGroupValue.map(value => value.editable)
      )
    def parameterGroupValue
        : Option[io.github.vigoo.zioaws.memorydb.model.ParameterGroup.ReadOnly]
    def parameterGroup: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.ParameterGroup.ReadOnly
    ] = AwsError.unwrapOptionField("parameterGroup", parameterGroupValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ResetParameterGroupResponse
  ) extends io.github.vigoo.zioaws.memorydb.model.ResetParameterGroupResponse.ReadOnly {
    override def parameterGroupValue: Option[
      io.github.vigoo.zioaws.memorydb.model.ParameterGroup.ReadOnly
    ] = scala
      .Option(impl.parameterGroup())
      .map(value =>
        io.github.vigoo.zioaws.memorydb.model.ParameterGroup.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ResetParameterGroupResponse
  ): io.github.vigoo.zioaws.memorydb.model.ResetParameterGroupResponse.ReadOnly =
    new Wrapper(impl)
}
