package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ParameterNameValue(
    parameterName: Option[String] = None,
    parameterValue: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ParameterNameValue = {
    import ParameterNameValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ParameterNameValue
      .builder()
      .optionallyWith(parameterName.map(value => value: java.lang.String))(
        _.parameterName
      )
      .optionallyWith(parameterValue.map(value => value: java.lang.String))(
        _.parameterValue
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.ParameterNameValue.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.ParameterNameValue
      .wrap(buildAwsValue())
}
object ParameterNameValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ParameterNameValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.ParameterNameValue =
      io.github.vigoo.zioaws.memorydb.model.ParameterNameValue(
        parameterNameValue.map(value => value),
        parameterValueValue.map(value => value)
      )
    def parameterNameValue: Option[String]
    def parameterValueValue: Option[String]
    def parameterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterName", parameterNameValue)
    def parameterValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterValue", parameterValueValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ParameterNameValue
  ) extends io.github.vigoo.zioaws.memorydb.model.ParameterNameValue.ReadOnly {
    override def parameterNameValue: Option[String] =
      scala.Option(impl.parameterName()).map(value => value: String)
    override def parameterValueValue: Option[String] =
      scala.Option(impl.parameterValue()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ParameterNameValue
  ): io.github.vigoo.zioaws.memorydb.model.ParameterNameValue.ReadOnly =
    new Wrapper(impl)
}
