package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeParameterGroupsResponse(
    nextToken: Option[String] = None,
    parameterGroups: Option[
      Iterable[io.github.vigoo.zioaws.memorydb.model.ParameterGroup]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsResponse = {
    import DescribeParameterGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        parameterGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameterGroups)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.DescribeParameterGroupsResponse.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.DescribeParameterGroupsResponse
      .wrap(buildAwsValue())
}
object DescribeParameterGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.memorydb.model.DescribeParameterGroupsResponse =
      io.github.vigoo.zioaws.memorydb.model.DescribeParameterGroupsResponse(
        nextTokenValue.map(value => value),
        parameterGroupsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def nextTokenValue: Option[String]
    def parameterGroupsValue: Option[
      List[io.github.vigoo.zioaws.memorydb.model.ParameterGroup.ReadOnly]
    ]
    def nextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def parameterGroups: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.memorydb.model.ParameterGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("parameterGroups", parameterGroupsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsResponse
  ) extends io.github.vigoo.zioaws.memorydb.model.DescribeParameterGroupsResponse.ReadOnly {
    override def nextTokenValue: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override def parameterGroupsValue: Option[
      List[io.github.vigoo.zioaws.memorydb.model.ParameterGroup.ReadOnly]
    ] = scala
      .Option(impl.parameterGroups())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.memorydb.model.ParameterGroup.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsResponse
  ): io.github.vigoo.zioaws.memorydb.model.DescribeParameterGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
