package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Snapshot(
    name: Option[String] = None,
    status: Option[String] = None,
    source: Option[String] = None,
    kmsKeyId: Option[String] = None,
    arn: Option[String] = None,
    clusterConfiguration: Option[
      io.github.vigoo.zioaws.memorydb.model.ClusterConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.Snapshot = {
    import Snapshot.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.Snapshot
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(source.map(value => value: java.lang.String))(_.source)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(clusterConfiguration.map(value => value.buildAwsValue()))(
        _.clusterConfiguration
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.memorydb.model.Snapshot.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.Snapshot.wrap(buildAwsValue())
}
object Snapshot {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.memorydb.model.Snapshot] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.Snapshot =
      io.github.vigoo.zioaws.memorydb.model.Snapshot(
        nameValue.map(value => value),
        statusValue.map(value => value),
        sourceValue.map(value => value),
        kmsKeyIdValue.map(value => value),
        arnValue.map(value => value),
        clusterConfigurationValue.map(value => value.editable)
      )
    def nameValue: Option[String]
    def statusValue: Option[String]
    def sourceValue: Option[String]
    def kmsKeyIdValue: Option[String]
    def arnValue: Option[String]
    def clusterConfigurationValue: Option[
      io.github.vigoo.zioaws.memorydb.model.ClusterConfiguration.ReadOnly
    ]
    def name: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", nameValue)
    def status: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", statusValue)
    def source: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("source", sourceValue)
    def kmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyIdValue)
    def arn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arnValue)
    def clusterConfiguration: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.ClusterConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "clusterConfiguration",
      clusterConfigurationValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.Snapshot
  ) extends io.github.vigoo.zioaws.memorydb.model.Snapshot.ReadOnly {
    override def nameValue: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override def statusValue: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override def sourceValue: Option[String] =
      scala.Option(impl.source()).map(value => value: String)
    override def kmsKeyIdValue: Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override def arnValue: Option[String] =
      scala.Option(impl.arn()).map(value => value: String)
    override def clusterConfigurationValue: Option[
      io.github.vigoo.zioaws.memorydb.model.ClusterConfiguration.ReadOnly
    ] = scala
      .Option(impl.clusterConfiguration())
      .map(value =>
        io.github.vigoo.zioaws.memorydb.model.ClusterConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.Snapshot
  ): io.github.vigoo.zioaws.memorydb.model.Snapshot.ReadOnly = new Wrapper(impl)
}
