package io.github.vigoo.zioaws.memorydb.model
import io.github.vigoo.zioaws.memorydb.model.primitives.UserName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteUserRequest(userName: UserName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DeleteUserRequest = {
    import DeleteUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DeleteUserRequest
      .builder()
      .userName(userName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.DeleteUserRequest.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.DeleteUserRequest
      .wrap(buildAwsValue())
}
object DeleteUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DeleteUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.DeleteUserRequest =
      io.github.vigoo.zioaws.memorydb.model.DeleteUserRequest(userNameValue)
    def userNameValue: UserName
    def userName: ZIO[Any, Nothing, UserName] = ZIO.succeed(userNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DeleteUserRequest
  ) extends io.github.vigoo.zioaws.memorydb.model.DeleteUserRequest.ReadOnly {
    override def userNameValue: UserName = impl.userName(): UserName
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DeleteUserRequest
  ): io.github.vigoo.zioaws.memorydb.model.DeleteUserRequest.ReadOnly =
    new Wrapper(impl)
}
