package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateSubnetGroupResponse(
    subnetGroup: Option[io.github.vigoo.zioaws.memorydb.model.SubnetGroup] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.CreateSubnetGroupResponse = {
    import CreateSubnetGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.CreateSubnetGroupResponse
      .builder()
      .optionallyWith(subnetGroup.map(value => value.buildAwsValue()))(
        _.subnetGroup
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.CreateSubnetGroupResponse.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.CreateSubnetGroupResponse
      .wrap(buildAwsValue())
}
object CreateSubnetGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.CreateSubnetGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.memorydb.model.CreateSubnetGroupResponse =
      io.github.vigoo.zioaws.memorydb.model.CreateSubnetGroupResponse(
        subnetGroupValue.map(value => value.editable)
      )
    def subnetGroupValue
        : Option[io.github.vigoo.zioaws.memorydb.model.SubnetGroup.ReadOnly]
    def subnetGroup: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.SubnetGroup.ReadOnly
    ] = AwsError.unwrapOptionField("subnetGroup", subnetGroupValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.CreateSubnetGroupResponse
  ) extends io.github.vigoo.zioaws.memorydb.model.CreateSubnetGroupResponse.ReadOnly {
    override def subnetGroupValue
        : Option[io.github.vigoo.zioaws.memorydb.model.SubnetGroup.ReadOnly] =
      scala
        .Option(impl.subnetGroup())
        .map(value =>
          io.github.vigoo.zioaws.memorydb.model.SubnetGroup.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.CreateSubnetGroupResponse
  ): io.github.vigoo.zioaws.memorydb.model.CreateSubnetGroupResponse.ReadOnly =
    new Wrapper(impl)
}
