package io.github.vigoo.zioaws.memorydb.model
import io.github.vigoo.zioaws.memorydb.model.primitives.UserName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ACLPendingChanges(
    userNamesToRemove: Option[Iterable[UserName]] = None,
    userNamesToAdd: Option[Iterable[UserName]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ACLPendingChanges = {
    import ACLPendingChanges.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ACLPendingChanges
      .builder()
      .optionallyWith(
        userNamesToRemove.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.userNamesToRemove)
      .optionallyWith(
        userNamesToAdd.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.userNamesToAdd)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.ACLPendingChanges.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.ACLPendingChanges
      .wrap(buildAwsValue())
}
object ACLPendingChanges {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ACLPendingChanges
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.ACLPendingChanges =
      io.github.vigoo.zioaws.memorydb.model.ACLPendingChanges(
        userNamesToRemoveValue.map(value => value),
        userNamesToAddValue.map(value => value)
      )
    def userNamesToRemoveValue: Option[List[UserName]]
    def userNamesToAddValue: Option[List[UserName]]
    def userNamesToRemove: ZIO[Any, AwsError, List[UserName]] =
      AwsError.unwrapOptionField("userNamesToRemove", userNamesToRemoveValue)
    def userNamesToAdd: ZIO[Any, AwsError, List[UserName]] =
      AwsError.unwrapOptionField("userNamesToAdd", userNamesToAddValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ACLPendingChanges
  ) extends io.github.vigoo.zioaws.memorydb.model.ACLPendingChanges.ReadOnly {
    override def userNamesToRemoveValue: Option[List[UserName]] = scala
      .Option(impl.userNamesToRemove())
      .map(value =>
        value.asScala.map { item =>
          item: UserName
        }.toList
      )
    override def userNamesToAddValue: Option[List[UserName]] = scala
      .Option(impl.userNamesToAdd())
      .map(value =>
        value.asScala.map { item =>
          item: UserName
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ACLPendingChanges
  ): io.github.vigoo.zioaws.memorydb.model.ACLPendingChanges.ReadOnly =
    new Wrapper(impl)
}
