package io.github.vigoo.zioaws.memorydb.model
import scala.jdk.CollectionConverters.*
sealed trait InputAuthenticationType {
  def unwrap
      : software.amazon.awssdk.services.memorydb.model.InputAuthenticationType
}
object InputAuthenticationType {
  def wrap(
      value: software.amazon.awssdk.services.memorydb.model.InputAuthenticationType
  ): io.github.vigoo.zioaws.memorydb.model.InputAuthenticationType =
    value match {
      case software.amazon.awssdk.services.memorydb.model.InputAuthenticationType.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.memorydb.model.InputAuthenticationType.PASSWORD =>
        val r = password
        r
    }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.memorydb.model.InputAuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.memorydb.model.InputAuthenticationType =
      software.amazon.awssdk.services.memorydb.model.InputAuthenticationType.UNKNOWN_TO_SDK_VERSION
  }
  case object password
      extends io.github.vigoo.zioaws.memorydb.model.InputAuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.memorydb.model.InputAuthenticationType =
      software.amazon.awssdk.services.memorydb.model.InputAuthenticationType.PASSWORD
  }
}
