package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeSubnetGroupsResponse(
    nextToken: Option[String] = None,
    subnetGroups: Option[
      Iterable[io.github.vigoo.zioaws.memorydb.model.SubnetGroup]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsResponse = {
    import DescribeSubnetGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        subnetGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subnetGroups)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.DescribeSubnetGroupsResponse.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.DescribeSubnetGroupsResponse
      .wrap(buildAwsValue())
}
object DescribeSubnetGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.memorydb.model.DescribeSubnetGroupsResponse =
      io.github.vigoo.zioaws.memorydb.model.DescribeSubnetGroupsResponse(
        nextTokenValue.map(value => value),
        subnetGroupsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def nextTokenValue: Option[String]
    def subnetGroupsValue: Option[
      List[io.github.vigoo.zioaws.memorydb.model.SubnetGroup.ReadOnly]
    ]
    def nextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def subnetGroups: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.memorydb.model.SubnetGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("subnetGroups", subnetGroupsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsResponse
  ) extends io.github.vigoo.zioaws.memorydb.model.DescribeSubnetGroupsResponse.ReadOnly {
    override def nextTokenValue: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override def subnetGroupsValue: Option[
      List[io.github.vigoo.zioaws.memorydb.model.SubnetGroup.ReadOnly]
    ] = scala
      .Option(impl.subnetGroups())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.memorydb.model.SubnetGroup.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsResponse
  ): io.github.vigoo.zioaws.memorydb.model.DescribeSubnetGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
