package io.github.vigoo.zioaws.memorydb.model
import scala.jdk.CollectionConverters.*
sealed trait SourceType {
  def unwrap: software.amazon.awssdk.services.memorydb.model.SourceType
}
object SourceType {
  def wrap(
      value: software.amazon.awssdk.services.memorydb.model.SourceType
  ): io.github.vigoo.zioaws.memorydb.model.SourceType = value match {
    case software.amazon.awssdk.services.memorydb.model.SourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.memorydb.model.SourceType.NODE =>
      val r = node
      r
    case software.amazon.awssdk.services.memorydb.model.SourceType.PARAMETER_GROUP =>
      val r = `parameter-group`
      r
    case software.amazon.awssdk.services.memorydb.model.SourceType.SUBNET_GROUP =>
      val r = `subnet-group`
      r
    case software.amazon.awssdk.services.memorydb.model.SourceType.CLUSTER =>
      val r = cluster
      r
    case software.amazon.awssdk.services.memorydb.model.SourceType.USER =>
      val r = user
      r
    case software.amazon.awssdk.services.memorydb.model.SourceType.ACL =>
      val r = acl
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.memorydb.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.memorydb.model.SourceType =
      software.amazon.awssdk.services.memorydb.model.SourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object node extends io.github.vigoo.zioaws.memorydb.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.memorydb.model.SourceType =
      software.amazon.awssdk.services.memorydb.model.SourceType.NODE
  }
  case object `parameter-group`
      extends io.github.vigoo.zioaws.memorydb.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.memorydb.model.SourceType =
      software.amazon.awssdk.services.memorydb.model.SourceType.PARAMETER_GROUP
  }
  case object `subnet-group`
      extends io.github.vigoo.zioaws.memorydb.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.memorydb.model.SourceType =
      software.amazon.awssdk.services.memorydb.model.SourceType.SUBNET_GROUP
  }
  case object cluster extends io.github.vigoo.zioaws.memorydb.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.memorydb.model.SourceType =
      software.amazon.awssdk.services.memorydb.model.SourceType.CLUSTER
  }
  case object user extends io.github.vigoo.zioaws.memorydb.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.memorydb.model.SourceType =
      software.amazon.awssdk.services.memorydb.model.SourceType.USER
  }
  case object acl extends io.github.vigoo.zioaws.memorydb.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.memorydb.model.SourceType =
      software.amazon.awssdk.services.memorydb.model.SourceType.ACL
  }
}
