package io.github.vigoo.zioaws.memorydb.model
import io.github.vigoo.zioaws.memorydb.model.primitives.UserName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateAclRequest(
    aclName: String,
    userNames: Option[Iterable[UserName]] = None,
    tags: Option[Iterable[io.github.vigoo.zioaws.memorydb.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.CreateAclRequest = {
    import CreateAclRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.CreateAclRequest
      .builder()
      .aclName(aclName: java.lang.String)
      .optionallyWith(
        userNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.userNames)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.CreateAclRequest.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.CreateAclRequest.wrap(buildAwsValue())
}
object CreateAclRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.CreateAclRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.CreateAclRequest =
      io.github.vigoo.zioaws.memorydb.model.CreateAclRequest(
        aclNameValue,
        userNamesValue.map(value => value),
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def aclNameValue: String
    def userNamesValue: Option[List[UserName]]
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.memorydb.model.Tag.ReadOnly]]
    def aclName: ZIO[Any, Nothing, String] = ZIO.succeed(aclNameValue)
    def userNames: ZIO[Any, AwsError, List[UserName]] =
      AwsError.unwrapOptionField("userNames", userNamesValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.memorydb.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.CreateAclRequest
  ) extends io.github.vigoo.zioaws.memorydb.model.CreateAclRequest.ReadOnly {
    override def aclNameValue: String = impl.aclName(): String
    override def userNamesValue: Option[List[UserName]] = scala
      .Option(impl.userNames())
      .map(value =>
        value.asScala.map { item =>
          item: UserName
        }.toList
      )
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.memorydb.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.memorydb.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.CreateAclRequest
  ): io.github.vigoo.zioaws.memorydb.model.CreateAclRequest.ReadOnly =
    new Wrapper(impl)
}
