package io.github.vigoo.zioaws.memorydb.model
import io.github.vigoo.zioaws.memorydb.model.primitives.IntegerOptional
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Shard(
    name: Option[String] = None,
    status: Option[String] = None,
    slots: Option[String] = None,
    nodes: Option[Iterable[io.github.vigoo.zioaws.memorydb.model.Node]] = None,
    numberOfNodes: Option[IntegerOptional] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.memorydb.model.Shard = {
    import Shard.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.Shard
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(slots.map(value => value: java.lang.String))(_.slots)
      .optionallyWith(
        nodes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.nodes)
      .optionallyWith(numberOfNodes.map(value => value: Integer))(
        _.numberOfNodes
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.memorydb.model.Shard.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.Shard.wrap(buildAwsValue())
}
object Shard {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.memorydb.model.Shard] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.Shard =
      io.github.vigoo.zioaws.memorydb.model.Shard(
        nameValue.map(value => value),
        statusValue.map(value => value),
        slotsValue.map(value => value),
        nodesValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        numberOfNodesValue.map(value => value)
      )
    def nameValue: Option[String]
    def statusValue: Option[String]
    def slotsValue: Option[String]
    def nodesValue
        : Option[List[io.github.vigoo.zioaws.memorydb.model.Node.ReadOnly]]
    def numberOfNodesValue: Option[IntegerOptional]
    def name: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", nameValue)
    def status: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", statusValue)
    def slots: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("slots", slotsValue)
    def nodes: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.memorydb.model.Node.ReadOnly
    ]] = AwsError.unwrapOptionField("nodes", nodesValue)
    def numberOfNodes: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numberOfNodes", numberOfNodesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.Shard
  ) extends io.github.vigoo.zioaws.memorydb.model.Shard.ReadOnly {
    override def nameValue: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override def statusValue: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override def slotsValue: Option[String] =
      scala.Option(impl.slots()).map(value => value: String)
    override def nodesValue
        : Option[List[io.github.vigoo.zioaws.memorydb.model.Node.ReadOnly]] =
      scala
        .Option(impl.nodes())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.memorydb.model.Node.wrap(item)
          }.toList
        )
    override def numberOfNodesValue: Option[IntegerOptional] =
      scala.Option(impl.numberOfNodes()).map(value => value: IntegerOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.Shard
  ): io.github.vigoo.zioaws.memorydb.model.Shard.ReadOnly = new Wrapper(impl)
}
