package io.github.vigoo.zioaws.memorydb.model
import io.github.vigoo.zioaws.memorydb.model.primitives.{
  ACLName,
  BooleanOptional,
  IntegerOptional
}
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateClusterRequest(
    clusterName: String,
    nodeType: String,
    parameterGroupName: Option[String] = None,
    description: Option[String] = None,
    numShards: Option[IntegerOptional] = None,
    numReplicasPerShard: Option[IntegerOptional] = None,
    subnetGroupName: Option[String] = None,
    securityGroupIds: Option[Iterable[String]] = None,
    maintenanceWindow: Option[String] = None,
    port: Option[IntegerOptional] = None,
    snsTopicArn: Option[String] = None,
    tlsEnabled: Option[BooleanOptional] = None,
    kmsKeyId: Option[String] = None,
    snapshotArns: Option[Iterable[String]] = None,
    snapshotName: Option[String] = None,
    snapshotRetentionLimit: Option[IntegerOptional] = None,
    tags: Option[Iterable[io.github.vigoo.zioaws.memorydb.model.Tag]] = None,
    snapshotWindow: Option[String] = None,
    aclName: ACLName,
    engineVersion: Option[String] = None,
    autoMinorVersionUpgrade: Option[BooleanOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.CreateClusterRequest = {
    import CreateClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.CreateClusterRequest
      .builder()
      .clusterName(clusterName: java.lang.String)
      .nodeType(nodeType: java.lang.String)
      .optionallyWith(parameterGroupName.map(value => value: java.lang.String))(
        _.parameterGroupName
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(numShards.map(value => value: Integer))(_.numShards)
      .optionallyWith(numReplicasPerShard.map(value => value: Integer))(
        _.numReplicasPerShard
      )
      .optionallyWith(subnetGroupName.map(value => value: java.lang.String))(
        _.subnetGroupName
      )
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(maintenanceWindow.map(value => value: java.lang.String))(
        _.maintenanceWindow
      )
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(snsTopicArn.map(value => value: java.lang.String))(
        _.snsTopicArn
      )
      .optionallyWith(tlsEnabled.map(value => value: java.lang.Boolean))(
        _.tlsEnabled
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        snapshotArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.snapshotArns)
      .optionallyWith(snapshotName.map(value => value: java.lang.String))(
        _.snapshotName
      )
      .optionallyWith(snapshotRetentionLimit.map(value => value: Integer))(
        _.snapshotRetentionLimit
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(snapshotWindow.map(value => value: java.lang.String))(
        _.snapshotWindow
      )
      .aclName(aclName: java.lang.String)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        autoMinorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.autoMinorVersionUpgrade)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.CreateClusterRequest.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.CreateClusterRequest
      .wrap(buildAwsValue())
}
object CreateClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.CreateClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.CreateClusterRequest =
      io.github.vigoo.zioaws.memorydb.model.CreateClusterRequest(
        clusterNameValue,
        nodeTypeValue,
        parameterGroupNameValue.map(value => value),
        descriptionValue.map(value => value),
        numShardsValue.map(value => value),
        numReplicasPerShardValue.map(value => value),
        subnetGroupNameValue.map(value => value),
        securityGroupIdsValue.map(value => value),
        maintenanceWindowValue.map(value => value),
        portValue.map(value => value),
        snsTopicArnValue.map(value => value),
        tlsEnabledValue.map(value => value),
        kmsKeyIdValue.map(value => value),
        snapshotArnsValue.map(value => value),
        snapshotNameValue.map(value => value),
        snapshotRetentionLimitValue.map(value => value),
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        snapshotWindowValue.map(value => value),
        aclNameValue,
        engineVersionValue.map(value => value),
        autoMinorVersionUpgradeValue.map(value => value)
      )
    def clusterNameValue: String
    def nodeTypeValue: String
    def parameterGroupNameValue: Option[String]
    def descriptionValue: Option[String]
    def numShardsValue: Option[IntegerOptional]
    def numReplicasPerShardValue: Option[IntegerOptional]
    def subnetGroupNameValue: Option[String]
    def securityGroupIdsValue: Option[List[String]]
    def maintenanceWindowValue: Option[String]
    def portValue: Option[IntegerOptional]
    def snsTopicArnValue: Option[String]
    def tlsEnabledValue: Option[BooleanOptional]
    def kmsKeyIdValue: Option[String]
    def snapshotArnsValue: Option[List[String]]
    def snapshotNameValue: Option[String]
    def snapshotRetentionLimitValue: Option[IntegerOptional]
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.memorydb.model.Tag.ReadOnly]]
    def snapshotWindowValue: Option[String]
    def aclNameValue: ACLName
    def engineVersionValue: Option[String]
    def autoMinorVersionUpgradeValue: Option[BooleanOptional]
    def clusterName: ZIO[Any, Nothing, String] = ZIO.succeed(clusterNameValue)
    def nodeType: ZIO[Any, Nothing, String] = ZIO.succeed(nodeTypeValue)
    def parameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterGroupName", parameterGroupNameValue)
    def description: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", descriptionValue)
    def numShards: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numShards", numShardsValue)
    def numReplicasPerShard: ZIO[Any, AwsError, IntegerOptional] = AwsError
      .unwrapOptionField("numReplicasPerShard", numReplicasPerShardValue)
    def subnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetGroupName", subnetGroupNameValue)
    def securityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIdsValue)
    def maintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maintenanceWindow", maintenanceWindowValue)
    def port: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", portValue)
    def snsTopicArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArnValue)
    def tlsEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("tlsEnabled", tlsEnabledValue)
    def kmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyIdValue)
    def snapshotArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("snapshotArns", snapshotArnsValue)
    def snapshotName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotName", snapshotNameValue)
    def snapshotRetentionLimit: ZIO[Any, AwsError, IntegerOptional] = AwsError
      .unwrapOptionField("snapshotRetentionLimit", snapshotRetentionLimitValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.memorydb.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
    def snapshotWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotWindow", snapshotWindowValue)
    def aclName: ZIO[Any, Nothing, ACLName] = ZIO.succeed(aclNameValue)
    def engineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersionValue)
    def autoMinorVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "autoMinorVersionUpgrade",
        autoMinorVersionUpgradeValue
      )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.CreateClusterRequest
  ) extends io.github.vigoo.zioaws.memorydb.model.CreateClusterRequest.ReadOnly {
    override def clusterNameValue: String = impl.clusterName(): String
    override def nodeTypeValue: String = impl.nodeType(): String
    override def parameterGroupNameValue: Option[String] =
      scala.Option(impl.parameterGroupName()).map(value => value: String)
    override def descriptionValue: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override def numShardsValue: Option[IntegerOptional] =
      scala.Option(impl.numShards()).map(value => value: IntegerOptional)
    override def numReplicasPerShardValue: Option[IntegerOptional] = scala
      .Option(impl.numReplicasPerShard())
      .map(value => value: IntegerOptional)
    override def subnetGroupNameValue: Option[String] =
      scala.Option(impl.subnetGroupName()).map(value => value: String)
    override def securityGroupIdsValue: Option[List[String]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override def maintenanceWindowValue: Option[String] =
      scala.Option(impl.maintenanceWindow()).map(value => value: String)
    override def portValue: Option[IntegerOptional] =
      scala.Option(impl.port()).map(value => value: IntegerOptional)
    override def snsTopicArnValue: Option[String] =
      scala.Option(impl.snsTopicArn()).map(value => value: String)
    override def tlsEnabledValue: Option[BooleanOptional] =
      scala.Option(impl.tlsEnabled()).map(value => value: BooleanOptional)
    override def kmsKeyIdValue: Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override def snapshotArnsValue: Option[List[String]] = scala
      .Option(impl.snapshotArns())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override def snapshotNameValue: Option[String] =
      scala.Option(impl.snapshotName()).map(value => value: String)
    override def snapshotRetentionLimitValue: Option[IntegerOptional] = scala
      .Option(impl.snapshotRetentionLimit())
      .map(value => value: IntegerOptional)
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.memorydb.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.memorydb.model.Tag.wrap(item)
          }.toList
        )
    override def snapshotWindowValue: Option[String] =
      scala.Option(impl.snapshotWindow()).map(value => value: String)
    override def aclNameValue: ACLName = impl.aclName(): ACLName
    override def engineVersionValue: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override def autoMinorVersionUpgradeValue: Option[BooleanOptional] = scala
      .Option(impl.autoMinorVersionUpgrade())
      .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.CreateClusterRequest
  ): io.github.vigoo.zioaws.memorydb.model.CreateClusterRequest.ReadOnly =
    new Wrapper(impl)
}
