package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeEventsResponse(
    nextToken: Option[String] = None,
    events: Option[Iterable[io.github.vigoo.zioaws.memorydb.model.Event]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeEventsResponse = {
    import DescribeEventsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeEventsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        events.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.events)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.DescribeEventsResponse.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.DescribeEventsResponse
      .wrap(buildAwsValue())
}
object DescribeEventsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeEventsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.DescribeEventsResponse =
      io.github.vigoo.zioaws.memorydb.model.DescribeEventsResponse(
        nextTokenValue.map(value => value),
        eventsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def nextTokenValue: Option[String]
    def eventsValue
        : Option[List[io.github.vigoo.zioaws.memorydb.model.Event.ReadOnly]]
    def nextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def events: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.memorydb.model.Event.ReadOnly
    ]] = AwsError.unwrapOptionField("events", eventsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeEventsResponse
  ) extends io.github.vigoo.zioaws.memorydb.model.DescribeEventsResponse.ReadOnly {
    override def nextTokenValue: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override def eventsValue
        : Option[List[io.github.vigoo.zioaws.memorydb.model.Event.ReadOnly]] =
      scala
        .Option(impl.events())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.memorydb.model.Event.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeEventsResponse
  ): io.github.vigoo.zioaws.memorydb.model.DescribeEventsResponse.ReadOnly =
    new Wrapper(impl)
}
