package io.github.vigoo.zioaws.memorydb.model
import io.github.vigoo.zioaws.memorydb.model.primitives.UserName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ACL(
    name: Option[String] = None,
    status: Option[String] = None,
    userNames: Option[Iterable[UserName]] = None,
    minimumEngineVersion: Option[String] = None,
    pendingChanges: Option[
      io.github.vigoo.zioaws.memorydb.model.ACLPendingChanges
    ] = None,
    clusters: Option[Iterable[String]] = None,
    arn: Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.memorydb.model.ACL = {
    import ACL.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ACL
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        userNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.userNames)
      .optionallyWith(
        minimumEngineVersion.map(value => value: java.lang.String)
      )(_.minimumEngineVersion)
      .optionallyWith(pendingChanges.map(value => value.buildAwsValue()))(
        _.pendingChanges
      )
      .optionallyWith(
        clusters.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.clusters)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.memorydb.model.ACL.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.ACL.wrap(buildAwsValue())
}
object ACL {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.memorydb.model.ACL] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.ACL =
      io.github.vigoo.zioaws.memorydb.model.ACL(
        nameValue.map(value => value),
        statusValue.map(value => value),
        userNamesValue.map(value => value),
        minimumEngineVersionValue.map(value => value),
        pendingChangesValue.map(value => value.editable),
        clustersValue.map(value => value),
        arnValue.map(value => value)
      )
    def nameValue: Option[String]
    def statusValue: Option[String]
    def userNamesValue: Option[List[UserName]]
    def minimumEngineVersionValue: Option[String]
    def pendingChangesValue: Option[
      io.github.vigoo.zioaws.memorydb.model.ACLPendingChanges.ReadOnly
    ]
    def clustersValue: Option[List[String]]
    def arnValue: Option[String]
    def name: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", nameValue)
    def status: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", statusValue)
    def userNames: ZIO[Any, AwsError, List[UserName]] =
      AwsError.unwrapOptionField("userNames", userNamesValue)
    def minimumEngineVersion: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("minimumEngineVersion", minimumEngineVersionValue)
    def pendingChanges: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.ACLPendingChanges.ReadOnly
    ] = AwsError.unwrapOptionField("pendingChanges", pendingChangesValue)
    def clusters: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("clusters", clustersValue)
    def arn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arnValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ACL
  ) extends io.github.vigoo.zioaws.memorydb.model.ACL.ReadOnly {
    override def nameValue: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override def statusValue: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override def userNamesValue: Option[List[UserName]] = scala
      .Option(impl.userNames())
      .map(value =>
        value.asScala.map { item =>
          item: UserName
        }.toList
      )
    override def minimumEngineVersionValue: Option[String] =
      scala.Option(impl.minimumEngineVersion()).map(value => value: String)
    override def pendingChangesValue: Option[
      io.github.vigoo.zioaws.memorydb.model.ACLPendingChanges.ReadOnly
    ] = scala
      .Option(impl.pendingChanges())
      .map(value =>
        io.github.vigoo.zioaws.memorydb.model.ACLPendingChanges.wrap(value)
      )
    override def clustersValue: Option[List[String]] = scala
      .Option(impl.clusters())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override def arnValue: Option[String] =
      scala.Option(impl.arn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ACL
  ): io.github.vigoo.zioaws.memorydb.model.ACL.ReadOnly = new Wrapper(impl)
}
