package io.github.vigoo.zioaws.memorydb.model
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Endpoint(
    address: Option[String] = None,
    port: Option[io.github.vigoo.zioaws.memorydb.model.primitives.Integer] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.Endpoint = {
    import Endpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.Endpoint
      .builder()
      .optionallyWith(address.map(value => value: java.lang.String))(_.address)
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.memorydb.model.Endpoint.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.Endpoint.wrap(buildAwsValue())
}
object Endpoint {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.memorydb.model.Endpoint] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.Endpoint =
      io.github.vigoo.zioaws.memorydb.model.Endpoint(
        addressValue.map(value => value),
        portValue.map(value => value)
      )
    def addressValue: Option[String]
    def portValue
        : Option[io.github.vigoo.zioaws.memorydb.model.primitives.Integer]
    def address: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("address", addressValue)
    def port: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.primitives.Integer
    ] = AwsError.unwrapOptionField("port", portValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.Endpoint
  ) extends io.github.vigoo.zioaws.memorydb.model.Endpoint.ReadOnly {
    override def addressValue: Option[String] =
      scala.Option(impl.address()).map(value => value: String)
    override def portValue
        : Option[io.github.vigoo.zioaws.memorydb.model.primitives.Integer] =
      scala
        .Option(impl.port())
        .map(value =>
          value: io.github.vigoo.zioaws.memorydb.model.primitives.Integer
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.Endpoint
  ): io.github.vigoo.zioaws.memorydb.model.Endpoint.ReadOnly = new Wrapper(impl)
}
