package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateUserResponse(
    user: Option[io.github.vigoo.zioaws.memorydb.model.User] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.UpdateUserResponse = {
    import UpdateUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.UpdateUserResponse
      .builder()
      .optionallyWith(user.map(value => value.buildAwsValue()))(_.user)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.UpdateUserResponse.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.UpdateUserResponse
      .wrap(buildAwsValue())
}
object UpdateUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.UpdateUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.UpdateUserResponse =
      io.github.vigoo.zioaws.memorydb.model
        .UpdateUserResponse(userValue.map(value => value.editable))
    def userValue: Option[io.github.vigoo.zioaws.memorydb.model.User.ReadOnly]
    def user: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.User.ReadOnly
    ] = AwsError.unwrapOptionField("user", userValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.UpdateUserResponse
  ) extends io.github.vigoo.zioaws.memorydb.model.UpdateUserResponse.ReadOnly {
    override def userValue
        : Option[io.github.vigoo.zioaws.memorydb.model.User.ReadOnly] = scala
      .Option(impl.user())
      .map(value => io.github.vigoo.zioaws.memorydb.model.User.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.UpdateUserResponse
  ): io.github.vigoo.zioaws.memorydb.model.UpdateUserResponse.ReadOnly =
    new Wrapper(impl)
}
