package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateAclResponse(
    acl: Option[io.github.vigoo.zioaws.memorydb.model.ACL] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.UpdateAclResponse = {
    import UpdateAclResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.UpdateAclResponse
      .builder()
      .optionallyWith(acl.map(value => value.buildAwsValue()))(_.acl)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.UpdateAclResponse.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.UpdateAclResponse
      .wrap(buildAwsValue())
}
object UpdateAclResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.UpdateAclResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.UpdateAclResponse =
      io.github.vigoo.zioaws.memorydb.model
        .UpdateAclResponse(aclValue.map(value => value.editable))
    def aclValue: Option[io.github.vigoo.zioaws.memorydb.model.ACL.ReadOnly]
    def acl: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.ACL.ReadOnly
    ] = AwsError.unwrapOptionField("acl", aclValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.UpdateAclResponse
  ) extends io.github.vigoo.zioaws.memorydb.model.UpdateAclResponse.ReadOnly {
    override def aclValue
        : Option[io.github.vigoo.zioaws.memorydb.model.ACL.ReadOnly] = scala
      .Option(impl.acl())
      .map(value => io.github.vigoo.zioaws.memorydb.model.ACL.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.UpdateAclResponse
  ): io.github.vigoo.zioaws.memorydb.model.UpdateAclResponse.ReadOnly =
    new Wrapper(impl)
}
