package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteAclResponse(
    acl: Option[io.github.vigoo.zioaws.memorydb.model.ACL] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DeleteAclResponse = {
    import DeleteAclResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DeleteAclResponse
      .builder()
      .optionallyWith(acl.map(value => value.buildAwsValue()))(_.acl)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.DeleteAclResponse.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.DeleteAclResponse
      .wrap(buildAwsValue())
}
object DeleteAclResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DeleteAclResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.DeleteAclResponse =
      io.github.vigoo.zioaws.memorydb.model
        .DeleteAclResponse(aclValue.map(value => value.editable))
    def aclValue: Option[io.github.vigoo.zioaws.memorydb.model.ACL.ReadOnly]
    def acl: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.ACL.ReadOnly
    ] = AwsError.unwrapOptionField("acl", aclValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DeleteAclResponse
  ) extends io.github.vigoo.zioaws.memorydb.model.DeleteAclResponse.ReadOnly {
    override def aclValue
        : Option[io.github.vigoo.zioaws.memorydb.model.ACL.ReadOnly] = scala
      .Option(impl.acl())
      .map(value => io.github.vigoo.zioaws.memorydb.model.ACL.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DeleteAclResponse
  ): io.github.vigoo.zioaws.memorydb.model.DeleteAclResponse.ReadOnly =
    new Wrapper(impl)
}
