package io.github.vigoo.zioaws.memorydb.model
import io.github.vigoo.zioaws.memorydb.model.primitives.IntegerOptional
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ClusterConfiguration(
    name: Option[String] = None,
    description: Option[String] = None,
    nodeType: Option[String] = None,
    engineVersion: Option[String] = None,
    maintenanceWindow: Option[String] = None,
    topicArn: Option[String] = None,
    port: Option[IntegerOptional] = None,
    parameterGroupName: Option[String] = None,
    subnetGroupName: Option[String] = None,
    vpcId: Option[String] = None,
    snapshotRetentionLimit: Option[IntegerOptional] = None,
    snapshotWindow: Option[String] = None,
    numShards: Option[IntegerOptional] = None,
    shards: Option[
      Iterable[io.github.vigoo.zioaws.memorydb.model.ShardDetail]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ClusterConfiguration = {
    import ClusterConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ClusterConfiguration
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(nodeType.map(value => value: java.lang.String))(
        _.nodeType
      )
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(maintenanceWindow.map(value => value: java.lang.String))(
        _.maintenanceWindow
      )
      .optionallyWith(topicArn.map(value => value: java.lang.String))(
        _.topicArn
      )
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(parameterGroupName.map(value => value: java.lang.String))(
        _.parameterGroupName
      )
      .optionallyWith(subnetGroupName.map(value => value: java.lang.String))(
        _.subnetGroupName
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(snapshotRetentionLimit.map(value => value: Integer))(
        _.snapshotRetentionLimit
      )
      .optionallyWith(snapshotWindow.map(value => value: java.lang.String))(
        _.snapshotWindow
      )
      .optionallyWith(numShards.map(value => value: Integer))(_.numShards)
      .optionallyWith(
        shards.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.shards)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.ClusterConfiguration.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.ClusterConfiguration
      .wrap(buildAwsValue())
}
object ClusterConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ClusterConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.ClusterConfiguration =
      io.github.vigoo.zioaws.memorydb.model.ClusterConfiguration(
        nameValue.map(value => value),
        descriptionValue.map(value => value),
        nodeTypeValue.map(value => value),
        engineVersionValue.map(value => value),
        maintenanceWindowValue.map(value => value),
        topicArnValue.map(value => value),
        portValue.map(value => value),
        parameterGroupNameValue.map(value => value),
        subnetGroupNameValue.map(value => value),
        vpcIdValue.map(value => value),
        snapshotRetentionLimitValue.map(value => value),
        snapshotWindowValue.map(value => value),
        numShardsValue.map(value => value),
        shardsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def nameValue: Option[String]
    def descriptionValue: Option[String]
    def nodeTypeValue: Option[String]
    def engineVersionValue: Option[String]
    def maintenanceWindowValue: Option[String]
    def topicArnValue: Option[String]
    def portValue: Option[IntegerOptional]
    def parameterGroupNameValue: Option[String]
    def subnetGroupNameValue: Option[String]
    def vpcIdValue: Option[String]
    def snapshotRetentionLimitValue: Option[IntegerOptional]
    def snapshotWindowValue: Option[String]
    def numShardsValue: Option[IntegerOptional]
    def shardsValue: Option[
      List[io.github.vigoo.zioaws.memorydb.model.ShardDetail.ReadOnly]
    ]
    def name: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", nameValue)
    def description: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", descriptionValue)
    def nodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeType", nodeTypeValue)
    def engineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersionValue)
    def maintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maintenanceWindow", maintenanceWindowValue)
    def topicArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("topicArn", topicArnValue)
    def port: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", portValue)
    def parameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterGroupName", parameterGroupNameValue)
    def subnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetGroupName", subnetGroupNameValue)
    def vpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcIdValue)
    def snapshotRetentionLimit: ZIO[Any, AwsError, IntegerOptional] = AwsError
      .unwrapOptionField("snapshotRetentionLimit", snapshotRetentionLimitValue)
    def snapshotWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotWindow", snapshotWindowValue)
    def numShards: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numShards", numShardsValue)
    def shards: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.memorydb.model.ShardDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("shards", shardsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ClusterConfiguration
  ) extends io.github.vigoo.zioaws.memorydb.model.ClusterConfiguration.ReadOnly {
    override def nameValue: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override def descriptionValue: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override def nodeTypeValue: Option[String] =
      scala.Option(impl.nodeType()).map(value => value: String)
    override def engineVersionValue: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override def maintenanceWindowValue: Option[String] =
      scala.Option(impl.maintenanceWindow()).map(value => value: String)
    override def topicArnValue: Option[String] =
      scala.Option(impl.topicArn()).map(value => value: String)
    override def portValue: Option[IntegerOptional] =
      scala.Option(impl.port()).map(value => value: IntegerOptional)
    override def parameterGroupNameValue: Option[String] =
      scala.Option(impl.parameterGroupName()).map(value => value: String)
    override def subnetGroupNameValue: Option[String] =
      scala.Option(impl.subnetGroupName()).map(value => value: String)
    override def vpcIdValue: Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override def snapshotRetentionLimitValue: Option[IntegerOptional] = scala
      .Option(impl.snapshotRetentionLimit())
      .map(value => value: IntegerOptional)
    override def snapshotWindowValue: Option[String] =
      scala.Option(impl.snapshotWindow()).map(value => value: String)
    override def numShardsValue: Option[IntegerOptional] =
      scala.Option(impl.numShards()).map(value => value: IntegerOptional)
    override def shardsValue: Option[
      List[io.github.vigoo.zioaws.memorydb.model.ShardDetail.ReadOnly]
    ] = scala
      .Option(impl.shards())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.memorydb.model.ShardDetail.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ClusterConfiguration
  ): io.github.vigoo.zioaws.memorydb.model.ClusterConfiguration.ReadOnly =
    new Wrapper(impl)
}
