package io.github.vigoo.zioaws.memorydb.model
import io.github.vigoo.zioaws.memorydb.model.primitives.{
  IntegerOptional,
  UserName
}
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeUsersRequest(
    userName: Option[UserName] = None,
    filters: Option[Iterable[io.github.vigoo.zioaws.memorydb.model.Filter]] =
      None,
    maxResults: Option[IntegerOptional] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeUsersRequest = {
    import DescribeUsersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeUsersRequest
      .builder()
      .optionallyWith(userName.map(value => value: java.lang.String))(
        _.userName
      )
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.DescribeUsersRequest.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.DescribeUsersRequest
      .wrap(buildAwsValue())
}
object DescribeUsersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeUsersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.DescribeUsersRequest =
      io.github.vigoo.zioaws.memorydb.model.DescribeUsersRequest(
        userNameValue.map(value => value),
        filtersValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        maxResultsValue.map(value => value),
        nextTokenValue.map(value => value)
      )
    def userNameValue: Option[UserName]
    def filtersValue
        : Option[List[io.github.vigoo.zioaws.memorydb.model.Filter.ReadOnly]]
    def maxResultsValue: Option[IntegerOptional]
    def nextTokenValue: Option[String]
    def userName: ZIO[Any, AwsError, UserName] =
      AwsError.unwrapOptionField("userName", userNameValue)
    def filters: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.memorydb.model.Filter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filtersValue)
    def maxResults: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def nextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeUsersRequest
  ) extends io.github.vigoo.zioaws.memorydb.model.DescribeUsersRequest.ReadOnly {
    override def userNameValue: Option[UserName] =
      scala.Option(impl.userName()).map(value => value: UserName)
    override def filtersValue
        : Option[List[io.github.vigoo.zioaws.memorydb.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.memorydb.model.Filter.wrap(item)
          }.toList
        )
    override def maxResultsValue: Option[IntegerOptional] =
      scala.Option(impl.maxResults()).map(value => value: IntegerOptional)
    override def nextTokenValue: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeUsersRequest
  ): io.github.vigoo.zioaws.memorydb.model.DescribeUsersRequest.ReadOnly =
    new Wrapper(impl)
}
