package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteSnapshotRequest(snapshotName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DeleteSnapshotRequest = {
    import DeleteSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DeleteSnapshotRequest
      .builder()
      .snapshotName(snapshotName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.DeleteSnapshotRequest.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.DeleteSnapshotRequest
      .wrap(buildAwsValue())
}
object DeleteSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DeleteSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.DeleteSnapshotRequest =
      io.github.vigoo.zioaws.memorydb.model
        .DeleteSnapshotRequest(snapshotNameValue)
    def snapshotNameValue: String
    def snapshotName: ZIO[Any, Nothing, String] = ZIO.succeed(snapshotNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DeleteSnapshotRequest
  ) extends io.github.vigoo.zioaws.memorydb.model.DeleteSnapshotRequest.ReadOnly {
    override def snapshotNameValue: String = impl.snapshotName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DeleteSnapshotRequest
  ): io.github.vigoo.zioaws.memorydb.model.DeleteSnapshotRequest.ReadOnly =
    new Wrapper(impl)
}
