package io.github.vigoo.zioaws.memorydb.model
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ReplicaConfigurationRequest(
    replicaCount: Option[
      io.github.vigoo.zioaws.memorydb.model.primitives.Integer
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ReplicaConfigurationRequest = {
    import ReplicaConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ReplicaConfigurationRequest
      .builder()
      .optionallyWith(replicaCount.map(value => value: Integer))(_.replicaCount)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.ReplicaConfigurationRequest.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.ReplicaConfigurationRequest
      .wrap(buildAwsValue())
}
object ReplicaConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ReplicaConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.memorydb.model.ReplicaConfigurationRequest =
      io.github.vigoo.zioaws.memorydb.model
        .ReplicaConfigurationRequest(replicaCountValue.map(value => value))
    def replicaCountValue
        : Option[io.github.vigoo.zioaws.memorydb.model.primitives.Integer]
    def replicaCount: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.primitives.Integer
    ] = AwsError.unwrapOptionField("replicaCount", replicaCountValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ReplicaConfigurationRequest
  ) extends io.github.vigoo.zioaws.memorydb.model.ReplicaConfigurationRequest.ReadOnly {
    override def replicaCountValue
        : Option[io.github.vigoo.zioaws.memorydb.model.primitives.Integer] =
      scala
        .Option(impl.replicaCount())
        .map(value =>
          value: io.github.vigoo.zioaws.memorydb.model.primitives.Integer
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ReplicaConfigurationRequest
  ): io.github.vigoo.zioaws.memorydb.model.ReplicaConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
