package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeAcLsResponse(
    acLs: Option[Iterable[io.github.vigoo.zioaws.memorydb.model.ACL]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeAcLsResponse = {
    import DescribeAcLsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeAcLsResponse
      .builder()
      .optionallyWith(
        acLs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.acLs)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.DescribeAcLsResponse.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.DescribeAcLsResponse
      .wrap(buildAwsValue())
}
object DescribeAcLsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeAcLsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.DescribeAcLsResponse =
      io.github.vigoo.zioaws.memorydb.model.DescribeAcLsResponse(
        acLsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextTokenValue.map(value => value)
      )
    def acLsValue
        : Option[List[io.github.vigoo.zioaws.memorydb.model.ACL.ReadOnly]]
    def nextTokenValue: Option[String]
    def acLs: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.memorydb.model.ACL.ReadOnly
    ]] = AwsError.unwrapOptionField("acLs", acLsValue)
    def nextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeAcLsResponse
  ) extends io.github.vigoo.zioaws.memorydb.model.DescribeAcLsResponse.ReadOnly {
    override def acLsValue
        : Option[List[io.github.vigoo.zioaws.memorydb.model.ACL.ReadOnly]] =
      scala
        .Option(impl.acLs())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.memorydb.model.ACL.wrap(item)
          }.toList
        )
    override def nextTokenValue: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeAcLsResponse
  ): io.github.vigoo.zioaws.memorydb.model.DescribeAcLsResponse.ReadOnly =
    new Wrapper(impl)
}
