package io.github.vigoo.zioaws.memorydb.model
import io.github.vigoo.zioaws.memorydb.model.primitives.UserName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateAclRequest(
    aclName: String,
    userNamesToAdd: Option[Iterable[UserName]] = None,
    userNamesToRemove: Option[Iterable[UserName]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.UpdateAclRequest = {
    import UpdateAclRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.UpdateAclRequest
      .builder()
      .aclName(aclName: java.lang.String)
      .optionallyWith(
        userNamesToAdd.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.userNamesToAdd)
      .optionallyWith(
        userNamesToRemove.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.userNamesToRemove)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.UpdateAclRequest.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.UpdateAclRequest.wrap(buildAwsValue())
}
object UpdateAclRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.UpdateAclRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.UpdateAclRequest =
      io.github.vigoo.zioaws.memorydb.model.UpdateAclRequest(
        aclNameValue,
        userNamesToAddValue.map(value => value),
        userNamesToRemoveValue.map(value => value)
      )
    def aclNameValue: String
    def userNamesToAddValue: Option[List[UserName]]
    def userNamesToRemoveValue: Option[List[UserName]]
    def aclName: ZIO[Any, Nothing, String] = ZIO.succeed(aclNameValue)
    def userNamesToAdd: ZIO[Any, AwsError, List[UserName]] =
      AwsError.unwrapOptionField("userNamesToAdd", userNamesToAddValue)
    def userNamesToRemove: ZIO[Any, AwsError, List[UserName]] =
      AwsError.unwrapOptionField("userNamesToRemove", userNamesToRemoveValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.UpdateAclRequest
  ) extends io.github.vigoo.zioaws.memorydb.model.UpdateAclRequest.ReadOnly {
    override def aclNameValue: String = impl.aclName(): String
    override def userNamesToAddValue: Option[List[UserName]] = scala
      .Option(impl.userNamesToAdd())
      .map(value =>
        value.asScala.map { item =>
          item: UserName
        }.toList
      )
    override def userNamesToRemoveValue: Option[List[UserName]] = scala
      .Option(impl.userNamesToRemove())
      .map(value =>
        value.asScala.map { item =>
          item: UserName
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.UpdateAclRequest
  ): io.github.vigoo.zioaws.memorydb.model.UpdateAclRequest.ReadOnly =
    new Wrapper(impl)
}
