package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SecurityGroupMembership(
    securityGroupId: Option[String] = None,
    status: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.SecurityGroupMembership = {
    import SecurityGroupMembership.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.SecurityGroupMembership
      .builder()
      .optionallyWith(securityGroupId.map(value => value: java.lang.String))(
        _.securityGroupId
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.SecurityGroupMembership.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.SecurityGroupMembership
      .wrap(buildAwsValue())
}
object SecurityGroupMembership {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.SecurityGroupMembership
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.memorydb.model.SecurityGroupMembership =
      io.github.vigoo.zioaws.memorydb.model.SecurityGroupMembership(
        securityGroupIdValue.map(value => value),
        statusValue.map(value => value)
      )
    def securityGroupIdValue: Option[String]
    def statusValue: Option[String]
    def securityGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("securityGroupId", securityGroupIdValue)
    def status: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", statusValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.SecurityGroupMembership
  ) extends io.github.vigoo.zioaws.memorydb.model.SecurityGroupMembership.ReadOnly {
    override def securityGroupIdValue: Option[String] =
      scala.Option(impl.securityGroupId()).map(value => value: String)
    override def statusValue: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.SecurityGroupMembership
  ): io.github.vigoo.zioaws.memorydb.model.SecurityGroupMembership.ReadOnly =
    new Wrapper(impl)
}
