package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListAllowedNodeTypeUpdatesResponse(
    scaleUpNodeTypes: Option[Iterable[String]] = None,
    scaleDownNodeTypes: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ListAllowedNodeTypeUpdatesResponse = {
    import ListAllowedNodeTypeUpdatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ListAllowedNodeTypeUpdatesResponse
      .builder()
      .optionallyWith(
        scaleUpNodeTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.scaleUpNodeTypes)
      .optionallyWith(
        scaleDownNodeTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.scaleDownNodeTypes)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.ListAllowedNodeTypeUpdatesResponse.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.ListAllowedNodeTypeUpdatesResponse
      .wrap(buildAwsValue())
}
object ListAllowedNodeTypeUpdatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ListAllowedNodeTypeUpdatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.memorydb.model.ListAllowedNodeTypeUpdatesResponse =
      io.github.vigoo.zioaws.memorydb.model.ListAllowedNodeTypeUpdatesResponse(
        scaleUpNodeTypesValue.map(value => value),
        scaleDownNodeTypesValue.map(value => value)
      )
    def scaleUpNodeTypesValue: Option[List[String]]
    def scaleDownNodeTypesValue: Option[List[String]]
    def scaleUpNodeTypes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("scaleUpNodeTypes", scaleUpNodeTypesValue)
    def scaleDownNodeTypes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("scaleDownNodeTypes", scaleDownNodeTypesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ListAllowedNodeTypeUpdatesResponse
  ) extends io.github.vigoo.zioaws.memorydb.model.ListAllowedNodeTypeUpdatesResponse.ReadOnly {
    override def scaleUpNodeTypesValue: Option[List[String]] = scala
      .Option(impl.scaleUpNodeTypes())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override def scaleDownNodeTypesValue: Option[List[String]] = scala
      .Option(impl.scaleDownNodeTypes())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ListAllowedNodeTypeUpdatesResponse
  ): io.github.vigoo.zioaws.memorydb.model.ListAllowedNodeTypeUpdatesResponse.ReadOnly =
    new Wrapper(impl)
}
