package io.github.vigoo.zioaws.memorydb.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateSubnetGroupResponse(
    subnetGroup: Option[io.github.vigoo.zioaws.memorydb.model.SubnetGroup] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.UpdateSubnetGroupResponse = {
    import UpdateSubnetGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.UpdateSubnetGroupResponse
      .builder()
      .optionallyWith(subnetGroup.map(value => value.buildAwsValue()))(
        _.subnetGroup
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.memorydb.model.UpdateSubnetGroupResponse.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.UpdateSubnetGroupResponse
      .wrap(buildAwsValue())
}
object UpdateSubnetGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.UpdateSubnetGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.memorydb.model.UpdateSubnetGroupResponse =
      io.github.vigoo.zioaws.memorydb.model.UpdateSubnetGroupResponse(
        subnetGroupValue.map(value => value.editable)
      )
    def subnetGroupValue
        : Option[io.github.vigoo.zioaws.memorydb.model.SubnetGroup.ReadOnly]
    def subnetGroup: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.SubnetGroup.ReadOnly
    ] = AwsError.unwrapOptionField("subnetGroup", subnetGroupValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.UpdateSubnetGroupResponse
  ) extends io.github.vigoo.zioaws.memorydb.model.UpdateSubnetGroupResponse.ReadOnly {
    override def subnetGroupValue
        : Option[io.github.vigoo.zioaws.memorydb.model.SubnetGroup.ReadOnly] =
      scala
        .Option(impl.subnetGroup())
        .map(value =>
          io.github.vigoo.zioaws.memorydb.model.SubnetGroup.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.UpdateSubnetGroupResponse
  ): io.github.vigoo.zioaws.memorydb.model.UpdateSubnetGroupResponse.ReadOnly =
    new Wrapper(impl)
}
