package io.github.vigoo.zioaws.memorydb.model
import io.github.vigoo.zioaws.memorydb.model.primitives.TStamp
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ShardDetail(
    name: Option[String] = None,
    configuration: Option[
      io.github.vigoo.zioaws.memorydb.model.ShardConfiguration
    ] = None,
    size: Option[String] = None,
    snapshotCreationTime: Option[TStamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ShardDetail = {
    import ShardDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ShardDetail
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(size.map(value => value: java.lang.String))(_.size)
      .optionallyWith(snapshotCreationTime.map(value => value: Instant))(
        _.snapshotCreationTime
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.memorydb.model.ShardDetail.ReadOnly =
    io.github.vigoo.zioaws.memorydb.model.ShardDetail.wrap(buildAwsValue())
}
object ShardDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ShardDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.memorydb.model.ShardDetail =
      io.github.vigoo.zioaws.memorydb.model.ShardDetail(
        nameValue.map(value => value),
        configurationValue.map(value => value.editable),
        sizeValue.map(value => value),
        snapshotCreationTimeValue.map(value => value)
      )
    def nameValue: Option[String]
    def configurationValue: Option[
      io.github.vigoo.zioaws.memorydb.model.ShardConfiguration.ReadOnly
    ]
    def sizeValue: Option[String]
    def snapshotCreationTimeValue: Option[TStamp]
    def name: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", nameValue)
    def configuration: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.memorydb.model.ShardConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configurationValue)
    def size: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("size", sizeValue)
    def snapshotCreationTime: ZIO[Any, AwsError, TStamp] = AwsError
      .unwrapOptionField("snapshotCreationTime", snapshotCreationTimeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ShardDetail
  ) extends io.github.vigoo.zioaws.memorydb.model.ShardDetail.ReadOnly {
    override def nameValue: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override def configurationValue: Option[
      io.github.vigoo.zioaws.memorydb.model.ShardConfiguration.ReadOnly
    ] = scala
      .Option(impl.configuration())
      .map(value =>
        io.github.vigoo.zioaws.memorydb.model.ShardConfiguration.wrap(value)
      )
    override def sizeValue: Option[String] =
      scala.Option(impl.size()).map(value => value: String)
    override def snapshotCreationTimeValue: Option[TStamp] =
      scala.Option(impl.snapshotCreationTime()).map(value => value: TStamp)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ShardDetail
  ): io.github.vigoo.zioaws.memorydb.model.ShardDetail.ReadOnly = new Wrapper(
    impl
  )
}
